/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.DecorableBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Decorators;

public abstract class AbstractDecorableBuiltInBean<T>
extends AbstractBuiltInBean<T>
implements DecorableBean<T> {
    private final CurrentInjectionPoint cip;

    protected AbstractDecorableBuiltInBean(BeanManagerImpl beanManager, Class<T> type) {
        super(new StringBeanIdentifier(BeanIdentifiers.forBuiltInBean(beanManager, type, null)), beanManager, type);
        this.cip = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint ip = this.getInjectionPoint(this.cip);
        List<Decorator<?>> decorators = this.getDecorators(ip);
        T instance = this.newInstance(ip, creationalContext);
        if (decorators == null) {
            decorators = this.beanManager.resolveDecorators(Collections.singleton(ip.getType()), this.getQualifiers());
        }
        if (decorators.isEmpty()) {
            return instance;
        }
        return Decorators.getOuterDelegate(this, instance, creationalContext, this.getProxyClass(), (InjectionPoint)this.cip.peek(), this.getBeanManager(), decorators);
    }

    protected abstract T newInstance(InjectionPoint var1, CreationalContext<T> var2);

    protected abstract List<Decorator<?>> getDecorators(InjectionPoint var1);

    protected abstract Class<T> getProxyClass();

    protected InjectionPoint getInjectionPoint(CurrentInjectionPoint cip) {
        InjectionPoint ip = (InjectionPoint)cip.peek();
        return EmptyInjectionPoint.INSTANCE.equals(ip) ? null : ip;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.getClass();
    }

    @Override
    public List<Decorator<?>> getDecorators() {
        return this.beanManager.resolveDecorators(this.getTypes(), this.getQualifiers());
    }
}

