/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConfigRecordDAOImpl
extends BaseDAOImpl
implements ConfigRecordDAO {
    private final String tableName;
    private final String insertSQL;
    private final String selectRecordsSinceSQL;
    private final String selectAllSQL;

    ConfigRecordDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQCREC41");
        this.insertSQL = new StringBuilder(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        this.selectRecordsSinceSQL = new StringBuilder(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("CREATED_TS").append(" > ?").toString();
        this.selectAllSQL = new StringBuilder(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQCREC41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, byte[] recordData, long timeStamp) throws BrokerException {
        block12: {
            Exception myex;
            PreparedStatement pstmt;
            block11: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                    Util.setBytes(pstmt, 1, recordData);
                    pstmt.setLong(2, timeStamp);
                    pstmt.executeUpdate();
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4083", String.valueOf(timeStamp)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block12;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public List<ChangeRecordInfo> getRecordsSince(Connection conn, long timestamp) throws BrokerException {
        ArrayList<ChangeRecordInfo> records;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                records = new ArrayList<ChangeRecordInfo>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectRecordsSinceSQL);
                    pstmt.setLong(1, timestamp);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        try {
                            byte[] buf = Util.readBytes(rs, 1);
                            records.add(new ChangeRecordInfo(buf, 0L));
                        }
                        catch (IOException e) {
                            IOException ex = DBManager.wrapIOException("[" + this.selectRecordsSinceSQL + "]", e);
                            this.logger.logStack(32, "B4123", rs.getString(2), (Throwable)ex);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectRecordsSinceSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4082"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return records;
    }

    @Override
    public List<ChangeRecordInfo> getAllRecords(Connection conn) throws BrokerException {
        ArrayList<ChangeRecordInfo> records;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                records = new ArrayList<ChangeRecordInfo>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAllSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long createdTS = -1L;
                        try {
                            createdTS = rs.getLong(2);
                            byte[] buf = Util.readBytes(rs, 1);
                            records.add(new ChangeRecordInfo(buf, createdTS));
                        }
                        catch (IOException e) {
                            IOException ex = DBManager.wrapIOException("[" + this.selectAllSQL + "]", e);
                            this.logger.logStack(32, "B4123", String.valueOf(createdTS), (Throwable)ex);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4082"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return records;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put((CallSite)((Object)("Config Change Records(" + this.tableName + ")")), String.valueOf(count));
        return map;
    }
}

