/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.javax.rmi;

import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class PortableRemoteObject
implements PortableRemoteObjectDelegate {
    public void exportObject(Remote obj) throws RemoteException {
        if (obj == null) {
            throw new NullPointerException("invalid argument");
        }
        if (Util.getInstance().getTie(obj) != null) {
            throw new ExportException(obj.getClass().getName() + " already exported");
        }
        Tie theTie = Utility.loadTie(obj);
        if (theTie != null) {
            Util.getInstance().registerTarget(theTie, obj);
        } else {
            UnicastRemoteObject.exportObject(obj);
        }
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        Remote result = null;
        if (obj == null) {
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub(obj)) {
            return obj;
        }
        if (obj instanceof RemoteStub) {
            return obj;
        }
        Tie theTie = Util.getInstance().getTie(obj);
        if (theTie != null) {
            result = Utility.loadStub(theTie, null, null, true);
        } else if (Utility.loadTie(obj) == null) {
            result = RemoteObject.toStub(obj);
        }
        if (result == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return result;
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub(obj) || obj instanceof RemoteStub) {
            throw new NoSuchObjectException("Can only unexport a server object.");
        }
        Tie theTie = Util.getInstance().getTie(obj);
        if (theTie != null) {
            Util.getInstance().unexportObject(obj);
        } else if (Utility.loadTie(obj) == null) {
            UnicastRemoteObject.unexportObject(obj, true);
        } else {
            throw new NoSuchObjectException("Object not exported.");
        }
    }

    public java.lang.Object narrow(java.lang.Object narrowFrom, Class narrowTo) throws ClassCastException {
        java.lang.Object result = null;
        if (narrowFrom == null) {
            return null;
        }
        if (narrowTo == null) {
            throw new NullPointerException("invalid argument");
        }
        try {
            if (narrowTo.isAssignableFrom(narrowFrom.getClass())) {
                return narrowFrom;
            }
            if (ClassInfoCache.get(narrowTo).isInterface() && narrowTo != Serializable.class && narrowTo != Externalizable.class) {
                Object narrowObj = (Object)narrowFrom;
                String id = RepositoryId.createForAnyType(narrowTo);
                if (narrowObj._is_a(id)) {
                    return Utility.loadStub(narrowObj, narrowTo);
                }
                throw new ClassCastException("Object is not of remote type " + narrowTo.getName());
            }
            throw new ClassCastException("Class " + narrowTo.getName() + " is not a valid remote interface");
        }
        catch (Exception error) {
            ClassCastException cce = new ClassCastException();
            cce.initCause(error);
            throw cce;
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        if (target == null || source == null) {
            throw new NullPointerException("invalid argument");
        }
        ORB orb = null;
        try {
            if (StubAdapter.isStub(source)) {
                orb = StubAdapter.getORB(source);
            } else {
                Tie tie = Util.getInstance().getTie(source);
                if (tie != null) {
                    orb = tie.orb();
                }
            }
        }
        catch (SystemException e) {
            throw new RemoteException("'source' object not connected", e);
        }
        boolean targetIsIIOP = false;
        Tie targetTie = null;
        if (StubAdapter.isStub(target)) {
            targetIsIIOP = true;
        } else {
            targetTie = Util.getInstance().getTie(target);
            if (targetTie != null) {
                targetIsIIOP = true;
            }
        }
        if (!targetIsIIOP) {
            if (orb != null) {
                throw new RemoteException("'source' object exported to IIOP, 'target' is JRMP");
            }
        } else {
            if (orb == null) {
                throw new RemoteException("'source' object is JRMP, 'target' is IIOP");
            }
            try {
                if (targetTie != null) {
                    try {
                        ORB existingOrb = targetTie.orb();
                        if (existingOrb == orb) {
                            return;
                        }
                        throw new RemoteException("'target' object was already connected");
                    }
                    catch (SystemException existingOrb) {
                        targetTie.orb(orb);
                    }
                } else {
                    StubAdapter.connect(target, orb);
                }
            }
            catch (SystemException e) {
                throw new RemoteException("'target' object was already connected", e);
            }
        }
    }
}

