/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

public class GroupServiceFactory
extends IMQIPServiceFactory {
    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        String myname1 = "shared_old";
        String myname2 = "group_old";
        if (!myname1.equals(handlerName) && !myname2.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myname1);
        }
    }

    @Override
    public Service createService(String instancename, int type) throws BrokerException {
        if (!Globals.getConfig().getBooleanProperty("imq." + instancename + ".override")) {
            Globals.getConfig().put("imq." + instancename + ".tcp.blocking", "false");
            Globals.getConfig().put("imq." + instancename + ".tcp.useChannels", "true");
        } else {
            Globals.getLogger().log(4, "Overriding shared properties for instance " + instancename);
        }
        return super.createService(instancename, type);
    }

    @Override
    protected IMQService createService(String instancename, Protocol proto, PacketRouter router, int type, int min, int max) throws IOException {
        proto.configureBlocking(false);
        return new GroupService(instancename, proto, type, router, min, max);
    }
}

