/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.shared.common.error.StandardException;

class CallStatementNode
extends DMLStatementNode {
    private JavaToSQLValueNode methodCall;

    CallStatementNode(JavaToSQLValueNode javaToSQLValueNode, ContextManager contextManager) {
        super(null, contextManager);
        this.methodCall = javaToSQLValueNode;
        this.methodCall.getJavaValueNode().markForCallStatement();
    }

    @Override
    String statementToString() {
        return "CALL";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        SubqueryList subqueryList = new SubqueryList(this.getContextManager());
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.methodCall = (JavaToSQLValueNode)this.methodCall.bindExpression(new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), subqueryList, null);
        if (subqueryList.size() != 0) {
            throw StandardException.newException("42X74", new Object[0]);
        }
        this.checkReliability();
        this.getCompilerContext().popCurrentPrivType();
    }

    @Override
    public void optimizeStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        this.methodCall = (JavaToSQLValueNode)this.methodCall.preprocess(this.getCompilerContext().getNumTables(), new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateParameterValueSet(activationClassBuilder);
        JavaValueNode javaValueNode = this.methodCall.getJavaValueNode();
        javaValueNode.markReturnValueDiscarded();
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun("void", 1);
        methodBuilder2.addThrownException("java.lang.Exception");
        javaValueNode.generate(activationClassBuilder, methodBuilder2);
        methodBuilder2.endStatement();
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getCallStatementResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
    }

    @Override
    public ResultDescription makeResultDescription() {
        return null;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.methodCall != null) {
            this.methodCall = (JavaToSQLValueNode)this.methodCall.accept(visitor);
        }
    }

    @Override
    int getPrivType() {
        return 6;
    }

    private void checkReliability() throws StandardException {
        if (this.getSQLAllowedInProcedure() == 0 && this.getCompilerContext().getReliability() == 2048) {
            throw StandardException.newException("42Z9D.S.1", new Object[0]);
        }
    }

    private short getSQLAllowedInProcedure() {
        RoutineAliasInfo routineAliasInfo = ((MethodCallNode)this.methodCall.getJavaValueNode()).routineInfo;
        return routineAliasInfo.getSQLAllowed();
    }
}

