/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.util.CommandModelData;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jvnet.hk2.annotations.Service;

@Service(name="multimode")
@PerLookup
public class MultimodeCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private CLIContainer container;
    @Param(optional=true, shortName="f")
    private File file;
    @Param(name="printprompt", optional=true)
    private Boolean printPromptOpt;
    private boolean printPrompt;
    @Param(optional=true)
    private String encoding;
    private boolean echo;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);
    private static final boolean DISABLE_JLINE = Boolean.getBoolean("glassfish.disable.jline") || Boolean.parseBoolean(System.getenv("AS_DISABLE_JLINE"));

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.printPrompt = this.printPromptOpt != null ? this.printPromptOpt.booleanValue() : this.programOpts.isInteractive();
        this.echo = this.programOpts.isEcho();
    }

    @Override
    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData p = new CommandModelData.ParamModelData("printprompt", Boolean.TYPE, true, Boolean.toString(this.programOpts.isInteractive()));
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals("printprompt")) {
                uopts.add((CommandModel.ParamModel)p);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        int prompter2;
        BufferedReader reader = null;
        this.programOpts.setEcho(this.echo);
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                Prompter prompter2 = this.getPrompter();
                int n = this.executeCommands(prompter2);
                return n;
            }
            this.printPrompt = false;
            if (!this.file.canRead()) {
                throw new CommandException("File: " + String.valueOf(this.file) + " can not be read");
            }
            reader = this.encoding == null ? new BufferedReader(new FileReader(this.file, Charset.defaultCharset())) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            prompter2 = this.executeCommands(new BufferedReaderPrompter(reader));
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (this.file != null && reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return prompter2;
    }

    private Prompter basicPrompter() throws IOException {
        return new BufferedReaderPrompter(new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())));
    }

    private Prompter getPrompter() throws IOException {
        if (DISABLE_JLINE) {
            return this.basicPrompter();
        }
        try {
            return new JLinePrompter();
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to initialize the advanced console (JLine). Features like history and auto-completion will be disabled.");
            System.err.println("Cause: " + e.getMessage());
            return this.basicPrompter();
        }
    }

    private static Completer getCompleterForLocalCommand(String commandName, Class<?> klass) {
        List<OptionAndCompleter> optionsDesc = CommandModelImpl.init(klass, null, null).entrySet().stream().flatMap(parameter -> MultimodeCommand.toOptionAndCompleter((String)parameter.getKey(), (CommandModel.ParamModel)parameter.getValue())).collect(Collectors.toList());
        return MultimodeCommand.getArgumentCompleter(commandName, optionsDesc);
    }

    private static Completer getArgumentCompleter(String commandName, List<OptionAndCompleter> optionsDesc) {
        optionsDesc.add(new OptionAndCompleter("--help", (Completer)NullCompleter.INSTANCE, OptionAndCompleter.Type.LONG_OPTION));
        optionsDesc.add(new OptionAndCompleter("-?", (Completer)NullCompleter.INSTANCE, OptionAndCompleter.Type.SHORT_OPTION));
        List optionsString = optionsDesc.stream().filter(option -> option.type != OptionAndCompleter.Type.PRIMARY).map(option -> option.option).collect(Collectors.toList());
        List optDescs = optionsDesc.stream().flatMap(option -> {
            switch (option.type.ordinal()) {
                case 0: {
                    return Stream.of(new Completers.OptDesc(null, option.option, null, option.completer));
                }
                case 1: {
                    return Stream.of(new Completers.OptDesc(option.option, null, null, option.completer));
                }
                case 2: {
                    return Stream.of(new Completers.OptDesc[0]);
                }
            }
            throw new IllegalStateException(option.type.name());
        }).collect(Collectors.toList());
        Completer completerForPrimaryOption = optionsDesc.stream().filter(option -> option.type == OptionAndCompleter.Type.PRIMARY).map(option -> option.completer).findFirst().orElse((Completer)NullCompleter.INSTANCE);
        return new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{commandName}), new AggregateCompleter(new Completer[]{new Completers.OptionCompleter((Completer)new StringsCompleter(optionsString), ignored -> optDescs, 1), completerForPrimaryOption})});
    }

    private static Stream<OptionAndCompleter> toOptionAndCompleter(String parameterName, CommandModel.ParamModel option) {
        String optionName;
        Param param = option.getParam();
        String string = optionName = !"".equals(param.name()) ? param.name() : parameterName;
        if (MultimodeCommand.isInternalCommand(optionName)) {
            return Stream.of(new OptionAndCompleter[0]);
        }
        Stream.Builder<OptionAndCompleter> builder = Stream.builder();
        if (param.primary()) {
            builder.add(new OptionAndCompleter(optionName, MultimodeCommand.getValueCompleter(option), OptionAndCompleter.Type.PRIMARY));
            return builder.build();
        }
        String shortName = param.shortName();
        String alias = param.alias();
        if (!"".equals(alias)) {
            builder.add(new OptionAndCompleter("--" + alias, MultimodeCommand.getValueCompleter(option), OptionAndCompleter.Type.LONG_OPTION));
        }
        if (!"".equals(shortName)) {
            builder.add(new OptionAndCompleter("-" + shortName, MultimodeCommand.getValueCompleter(option), OptionAndCompleter.Type.SHORT_OPTION));
        }
        builder.add(new OptionAndCompleter("--" + optionName, MultimodeCommand.getValueCompleter(option), OptionAndCompleter.Type.LONG_OPTION));
        return builder.build();
    }

    private static Completer getValueCompleter(CommandModel.ParamModel option) {
        if (option.getType() == File.class) {
            return new Completers.FileNameCompleter();
        }
        if (option.getType() == Boolean.TYPE || option.getType() == Boolean.class) {
            return new StringsCompleter(new String[]{"true", "false"});
        }
        String acceptableValues = option.getParam().acceptableValues();
        if (!"".equals(acceptableValues)) {
            return new StringsCompleter((String[])Arrays.stream(acceptableValues.split("" + option.getParam().separator())).map(String::trim).toArray(String[]::new));
        }
        if (List.of("nodedir", "installdir", "sshkeyfile", "sshpublickeyfile", "backupdir", "domaindir", "filename", "sqlfilename", "adminpasswordfile", "classpath", "nativelibrarypath", "logfile", "transactionlogdir").contains(option.getName())) {
            return new Completers.FileNameCompleter();
        }
        return (line, parsedLine, candidates) -> {
            if (Stream.of(".", "..", "../", "~", "/", "..\\", "./").anyMatch(parsedLine.word()::startsWith)) {
                new Completers.FileNameCompleter().complete(line, parsedLine, candidates);
            }
        };
    }

    private static void atomicReplace(ServiceLocator locator, ProgramOptions options) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)ProgramOptions.class.getName()));
        AbstractActiveDescriptor desc = BuilderHelper.createConstantDescriptor((Object)options, null, (Type[])new Type[]{ProgramOptions.class});
        config.addActiveDescriptor((ActiveDescriptor)desc);
        config.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(Prompter prompter) throws CommandException, CommandValidationException, IOException {
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        String prompt = this.programOpts.getCommandName() + "> ";
        while (true) {
            String command;
            String[] args;
            String line;
            if ((line = prompter.prompt(prompt)) == null) {
                if (!this.printPrompt) break;
                System.out.println();
                break;
            }
            if (line.trim().startsWith("#")) continue;
            try {
                args = this.getArgs(line);
            }
            catch (ArgumentTokenizer.ArgumentException ex) {
                logger.info(ex.getMessage());
                continue;
            }
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            if (command.equals("osgi-shell")) {
                prompter.close();
            }
            CLICommand cmd = null;
            ProgramOptions po = null;
            try {
                po = new ProgramOptions(this.env);
                po.setModulePath(this.programOpts.getModulePath());
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                po.setCommandName(this.programOpts.getCommandName());
                MultimodeCommand.atomicReplace(this.habitat, po);
                cmd = CLICommand.getCommand(this.habitat, command);
                rc = cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.severe(cve.getMessage());
                if (cmd != null) {
                    logger.severe(cmd.getUsage());
                }
                rc = 1;
            }
            catch (InvalidCommandException ice) {
                logger.severe(ice.getMessage());
                try {
                    if (po != null) {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(this.container, po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"), logger);
                    }
                }
                catch (InvalidCommandException invalidCommandException) {
                    // empty catch block
                }
                rc = 1;
            }
            catch (CommandException ce) {
                if (ce.getCause() instanceof ConnectException) {
                    logger.severe(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(this.container), strings.get("ClosestMatchedLocalCommands"), logger);
                    }
                    catch (InvalidCommandException e) {
                        logger.info(strings.get("InvalidRemoteCommand", new Object[]{command}));
                    }
                } else {
                    logger.severe(ce.getMessage());
                }
                rc = 1;
            }
            finally {
                MultimodeCommand.atomicReplace(this.habitat, this.programOpts);
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.fine(strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                default: {
                    logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            CLIUtil.writeCommandToDebugLog(this.programOpts.getCommandName() + "[multimode]", this.env, args, rc);
        }
        return rc;
    }

    private static boolean isInternalCommand(String commandName) {
        return commandName == null || commandName.startsWith("_");
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }

    static interface Prompter {
        public String prompt(String var1) throws IOException;

        public void close() throws IOException;
    }

    class BufferedReaderPrompter
    implements Prompter {
        private final BufferedReader reader;

        BufferedReaderPrompter(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String prompt(String message) throws IOException {
            if (MultimodeCommand.this.printPrompt) {
                System.out.print(message);
                System.out.flush();
            }
            return this.reader.readLine();
        }

        @Override
        public void close() {
        }
    }

    class JLinePrompter
    implements Prompter {
        private LineReader reader;
        private Terminal terminal;

        JLinePrompter() throws IOException {
            this.setupTerminal();
        }

        private void setupTerminal() throws IOException {
            this.terminal = TerminalBuilder.builder().system(true).build();
            SystemCompleter systemCompleter = new SystemCompleter();
            MultimodeCommand.this.habitat.getDescriptors(descriptor -> descriptor.getAdvertisedContracts().contains("com.sun.enterprise.admin.cli.CLICommand")).forEach(activeDescriptor -> {
                String commandName = activeDescriptor.getName();
                if (MultimodeCommand.isInternalCommand(commandName)) {
                    return;
                }
                try {
                    MultimodeCommand.this.habitat.reifyDescriptor((Descriptor)activeDescriptor);
                    systemCompleter.add(commandName, MultimodeCommand.getCompleterForLocalCommand(commandName, activeDescriptor.getImplementationClass()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            systemCompleter.add(List.of("exit", "quit"), (Completer)NullCompleter.INSTANCE);
            systemCompleter.compile(Candidate::new);
            this.reader = LineReaderBuilder.builder().completer((Completer)new AggregateCompleter(new Completer[]{systemCompleter, new RemoteCommandsCompleter()})).variable("history-file", (Object)Paths.get(System.getProperty("user.home"), ".gfclient", ".cli-history")).terminal(this.terminal).build();
        }

        @Override
        public String prompt(String message) throws IOException {
            if (this.terminal == null) {
                this.setupTerminal();
            }
            try {
                if (MultimodeCommand.this.printPrompt) {
                    return this.reader.readLine(message);
                }
                return this.reader.readLine();
            }
            catch (EndOfFileException | UserInterruptException ignored) {
                return null;
            }
        }

        @Override
        public void close() throws IOException {
            this.reader = null;
            this.terminal.close();
            this.terminal = null;
        }
    }

    static class OptionAndCompleter {
        final String option;
        final Completer completer;
        final Type type;

        OptionAndCompleter(String option, Completer completer, Type type) {
            this.option = option;
            this.completer = completer;
            this.type = type;
        }

        public static enum Type {
            LONG_OPTION,
            SHORT_OPTION,
            PRIMARY;

        }
    }

    private class RemoteCommandsCompleter
    implements Completer {
        Completer cached;

        private RemoteCommandsCompleter() {
        }

        public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            try {
                if (this.cached == null && this.computeRemoteCommandsCache()) {
                    return;
                }
                this.cached.complete(lineReader, parsedLine, list);
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        }

        private boolean computeRemoteCommandsCache() throws CommandException {
            String[] remoteCommands = CLIUtil.getRemoteCommands(MultimodeCommand.this.container, MultimodeCommand.this.programOpts, MultimodeCommand.this.env);
            if (remoteCommands == null) {
                return true;
            }
            SystemCompleter systemCompleter = new SystemCompleter();
            for (String remoteCommand : remoteCommands) {
                if (MultimodeCommand.isInternalCommand(remoteCommand)) continue;
                List<OptionAndCompleter> options = this.getOptionsForCommand(remoteCommand).getParameters().stream().flatMap(parameter -> MultimodeCommand.toOptionAndCompleter(parameter.getName(), parameter)).collect(Collectors.toList());
                Completer argumentCompleter = MultimodeCommand.getArgumentCompleter(remoteCommand, options);
                systemCompleter.add(remoteCommand, argumentCompleter);
            }
            systemCompleter.compile(Candidate::new);
            this.cached = systemCompleter;
            return false;
        }

        private CommandModel getOptionsForCommand(String name1) {
            try {
                var remoteCLICommand = new RemoteCLICommand(name1, MultimodeCommand.this.programOpts, MultimodeCommand.this.env){

                    public CommandModel getCommandModel() throws CommandException {
                        this.argv = new String[]{this.name};
                        this.prepare();
                        this.parse();
                        return this.commandModel;
                    }
                };
                return remoteCLICommand.getCommandModel();
            }
            catch (CommandException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

