/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.TableIndex;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.TableElement;

public abstract class QueryPlan {
    public static final int ACT_UPDATE = 1;
    public static final int ACT_INSERT = 2;
    public static final int ACT_DELETE = 3;
    public static final int ACT_SELECT = 4;
    public static final int ACT_NOOP = 5;
    protected static final int ST_BUILT = 1;
    public ArrayList statements;
    protected ClassDesc config;
    protected int status;
    protected int action;
    protected SQLStoreManager store;
    protected ArrayList tables = new ArrayList();
    protected static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)QueryPlan.class.getClassLoader());

    public QueryPlan(ActionDesc desc, SQLStoreManager store) {
        this.statements = new ArrayList();
        this.store = store;
        this.config = (ClassDesc)store.getPersistenceConfig(desc.getPersistenceCapableClass());
    }

    public QueryTable addQueryTable(TableDesc tableDesc) {
        QueryTable table = new QueryTable(tableDesc);
        this.tables.add(table);
        table.setTableIndex(new TableIndex(this.tables.size() - 1));
        return table;
    }

    public QueryTable addQueryTable(TableElement tableElement, ClassDesc persistenceConfig) {
        ClassDesc _config = persistenceConfig == null ? this.config : persistenceConfig;
        TableDesc tableDesc = _config.findTableDesc(tableElement);
        if (tableDesc == null) {
            if (tableElement != null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.configuration.classnotmappedtotable", (Object[])new Object[]{_config.getPersistenceCapableClass().getName(), tableElement.getName().getName()}));
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.configuration.classnotmapped", (Object[])new Object[]{_config.getPersistenceCapableClass().getName()}));
        }
        return this.addQueryTable(tableDesc);
    }

    public void addQueryTables(ArrayList queryTables) {
        for (int i = 0; i < queryTables.size(); ++i) {
            QueryTable t = (QueryTable)queryTables.get(i);
            if (this.tables.indexOf(t) != -1) continue;
            this.tables.add(t);
            t.getTableIndex().setValue(this.tables.size() - 1);
        }
    }

    public QueryTable findQueryTable(TableElement tableElement) {
        for (int i = 0; i < this.tables.size(); ++i) {
            QueryTable t = (QueryTable)this.tables.get(i);
            if (t.getTableDesc().getTableElement() != tableElement) continue;
            return t;
        }
        return null;
    }

    public QueryTable findQueryTable(TableDesc tableDesc) {
        for (int i = 0; i < this.tables.size(); ++i) {
            QueryTable t = (QueryTable)this.tables.get(i);
            if (t.getTableDesc() != tableDesc) continue;
            return t;
        }
        return null;
    }

    public ArrayList getStatements() {
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement s = (Statement)this.statements.get(i);
            s.getText();
        }
        return this.statements;
    }

    protected Statement addStatement(QueryTable t) {
        Statement s = this.createStatement(t);
        this.statements.add(s);
        return s;
    }

    protected abstract Statement newStatement();

    protected Statement createStatement(QueryTable t) {
        Statement statement = this.newStatement();
        statement.action = this.action;
        statement.addQueryTable(t);
        return statement;
    }

    protected Statement getStatement(QueryTable t) {
        if (t == null) {
            return null;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement s = (Statement)this.statements.get(i);
            if (s.tableList.indexOf(t) == -1) continue;
            return s;
        }
        return null;
    }

    public abstract void build();

    protected void processStatements() {
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement s = (Statement)this.statements.get(i);
            QueryTable qt = (QueryTable)s.getQueryTables().get(0);
            ArrayList secondaryTableKeys = qt.getTableDesc().getSecondaryTableKeys();
            if (secondaryTableKeys == null) continue;
            for (int j = 0; j < secondaryTableKeys.size(); ++j) {
                ReferenceKeyDesc secondaryTableKey = (ReferenceKeyDesc)secondaryTableKeys.get(j);
                s.addSecondaryTableStatement(this.getStatement(this.findQueryTable(secondaryTableKey.getTableDesc())));
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public ClassDesc getConfig() {
        return this.config;
    }
}

