/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import java.util.concurrent.atomic.AtomicInteger;

public final class PoolSize {
    private final AtomicInteger currentCount = new AtomicInteger(0);
    private final int capacity;

    public PoolSize(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getCurrentCount() {
        return this.currentCount.get();
    }

    public void increment() throws PoolingException {
        if (this.currentCount.getAndUpdate(v -> Math.min(v + 1, this.capacity)) == this.capacity) {
            throw new PoolingException("Count of provided connections is already equal to the capacity (" + this.capacity + ") therefore you cannot allocate any more resources.");
        }
    }

    public void decrement() {
        this.currentCount.getAndUpdate(v -> Math.max(v - 1, 0));
    }

    public String toString() {
        return this.currentCount.toString();
    }
}

