/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Phase {
    private static final Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Timer timer;
        context.setCurrentPhaseId(this.getId());
        PhaseEvent event = null;
        if (listeners.hasNext()) {
            event = new PhaseEvent(context, this.getId(), lifecycle);
        }
        if ((timer = Timer.getInstance()) != null) {
            timer.startTiming();
        }
        try {
            this.handleBeforePhase(context, listeners, event);
            if (!this.shouldSkip(context)) {
                this.execute(context);
            }
        }
        catch (Throwable e) {
            this.queueException(context, e);
        }
        finally {
            try {
                this.handleAfterPhase(context, listeners, event);
            }
            catch (Throwable e) {
                this.queueException(context, e);
            }
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Execution time for phase (including any PhaseListeners) -> " + this.getId().toString());
            }
            context.getExceptionHandler().handle();
        }
    }

    public abstract void execute(FacesContext var1) throws FacesException;

    public abstract PhaseId getId();

    protected void queueException(FacesContext ctx, Throwable t) {
        this.queueException(ctx, t, null);
    }

    protected void queueException(FacesContext ctx, Throwable t, String booleanKey) {
        ExceptionQueuedEventContext extx = new ExceptionQueuedEventContext(ctx, t);
        if (booleanKey != null) {
            extx.getAttributes().put(booleanKey, Boolean.TRUE);
        }
        ctx.getApplication().publishEvent(ctx, ExceptionQueuedEvent.class, extx);
    }

    protected void handleAfterPhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        block5: {
            try {
                Flash flash = context.getExternalContext().getFlash();
                flash.doPostPhaseActions(context);
            }
            catch (UnsupportedOperationException uoe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block5;
                LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
            }
        }
        while (listenersIterator.hasPrevious()) {
            PhaseListener listener = listenersIterator.previous();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.afterPhase(event);
            }
            catch (Exception e) {
                this.queueException(context, e, ExceptionQueuedEventContext.IN_AFTER_PHASE_KEY);
                return;
            }
        }
    }

    protected void handleBeforePhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        block6: {
            try {
                Flash flash = context.getExternalContext().getFlash();
                flash.doPrePhaseActions(context);
            }
            catch (UnsupportedOperationException uoe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
            }
        }
        while (listenersIterator.hasNext()) {
            PhaseListener listener = listenersIterator.next();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.beforePhase(event);
            }
            catch (Exception e) {
                this.queueException(context, e, ExceptionQueuedEventContext.IN_BEFORE_PHASE_KEY);
                if (listenersIterator.hasPrevious()) {
                    listenersIterator.previous();
                }
                return;
            }
        }
    }

    private boolean shouldSkip(FacesContext context) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(this.getId());
    }
}

