/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class CommonClassLoaderServiceImpl {
    private static final Logger LOG = KernelLoggerInfo.getLogger();
    private static final String SERVER_EXCLUDED_ATTR_NAME = "GlassFish-ServerExcluded";
    @Inject
    APIClassLoaderServiceImpl acls;
    @Inject
    private ServerEnvironment env;
    private GlassfishUrlClassLoader commonClassLoader;
    private ClassLoader apiClassLoader;
    private String commonClassPath;

    @PostConstruct
    void postConstruct() {
        this.apiClassLoader = Objects.requireNonNull(this.acls.getAPIClassLoader(), "API ClassLoader is null!");
        List<URL> urls = CommonClassLoaderServiceImpl.toUrls(CommonClassLoaderServiceImpl.createClasspathElements(this.env));
        this.commonClassPath = CommonClassLoaderServiceImpl.urlsToClassPath(urls.stream());
        if (urls.isEmpty()) {
            LOG.logp(Level.FINE, "CommonClassLoaderManager", "Skipping creation of CommonClassLoader as there are no libraries available", "urls = {0}", urls);
        } else {
            this.commonClassLoader = new GlassfishUrlClassLoader("CommonLibs", (URL[])urls.toArray(URL[]::new), this.apiClassLoader);
            LOG.log(Level.FINE, "Created common classloader: {0}", this.commonClassLoader);
        }
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonClassLoader == null ? this.apiClassLoader : this.commonClassLoader;
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    public void addToClassPath(URL url) {
        CommonClassLoaderServiceImpl.validateUrl(url);
        if (this.commonClassLoader == null) {
            this.commonClassLoader = new GlassfishUrlClassLoader("CommonLibs", new URL[]{url}, this.apiClassLoader);
        } else {
            this.commonClassLoader.addURL(url);
        }
        this.commonClassPath = CommonClassLoaderServiceImpl.urlsToClassPath(Arrays.stream(this.commonClassLoader.getURLs()));
    }

    private static List<File> createClasspathElements(ServerEnvironment env) {
        Properties startupCtxArgs = env.getStartupContext().getArguments();
        ArrayList<File> cpElements = new ArrayList<File>();
        String installRoot = startupCtxArgs.getProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName());
        if (installRoot == null) {
            LOG.log(Level.WARNING, "The startup context property is not set: " + GlassFishVariable.INSTALL_ROOT.getPropertyName());
        } else {
            File installDir = new File(installRoot);
            LOG.log(Level.CONFIG, "Using install root: {0}", installRoot);
            File installLibDir = new File(installDir, "lib");
            if (installLibDir.isDirectory()) {
                Collections.addAll(cpElements, installLibDir.listFiles(new CompiletimeJarFileFilter()));
            }
            cpElements.addAll(CommonClassLoaderServiceImpl.findDerbyJars(installDir, startupCtxArgs));
        }
        File domainLibDir = new File(env.getInstanceRoot(), "lib");
        File domainClassesDir = new File(domainLibDir, "classes");
        if (domainClassesDir.exists()) {
            cpElements.add(domainClassesDir);
        }
        if (domainLibDir.isDirectory()) {
            Collections.addAll(cpElements, domainLibDir.listFiles(new JarFileFilter()));
        }
        return cpElements;
    }

    private static List<URL> toUrls(List<File> cpElements) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : cpElements) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "NCLS-CORE-00045", new Object[]{file, e});
            }
        }
        return urls;
    }

    private static URL validateUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URL must be a file URL");
        }
        if (url.getPath().isEmpty()) {
            throw new IllegalArgumentException("URL path cannot be empty");
        }
        return url;
    }

    private static String urlsToClassPath(Stream<URL> urls) {
        return urls.map(FileUtils::toFile).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private static List<File> findDerbyJars(File installDir, Properties startupCtxArgs) {
        Path derbyHome = CommonClassLoaderServiceImpl.getDerbyDir(installDir, startupCtxArgs);
        LOG.log(Level.CONFIG, "Using derby home: {0}", derbyHome);
        if (derbyHome == null) {
            LOG.log(Level.INFO, "NCLS-CORE-00046", "DerbyDB home is not set");
            return Collections.emptyList();
        }
        File derbyLib = derbyHome.resolve("lib").toFile();
        if (!derbyLib.exists()) {
            LOG.log(Level.INFO, "NCLS-CORE-00046", derbyLib);
            return Collections.emptyList();
        }
        return Arrays.asList(derbyLib.listFiles((dir, name) -> name.endsWith(".jar") && !name.startsWith("derbyLocale_")));
    }

    private static Path getDerbyDir(File installDir, Properties startupCtxArgs) {
        String derbyHomePropertyCtx = startupCtxArgs.getProperty(GlassFishVariable.DERBY_ROOT.getPropertyName());
        if (derbyHomePropertyCtx != null) {
            return new File(derbyHomePropertyCtx).toPath();
        }
        String derbyHomeProperty = System.getProperty(GlassFishVariable.DERBY_ROOT.getSystemPropertyName());
        if (derbyHomeProperty != null) {
            return new File(derbyHomeProperty).toPath();
        }
        return null;
    }

    private static class CompiletimeJarFileFilter
    extends JarFileFilter {
        private CompiletimeJarFileFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean accept(File dir, String name) {
            if (!super.accept(dir, name)) return false;
            File file = new File(dir, name);
            try (JarFile jar = new JarFile(file);){
                Manifest manifest = jar.getManifest();
                if (manifest == null) return true;
                String exclude = manifest.getMainAttributes().getValue(CommonClassLoaderServiceImpl.SERVER_EXCLUDED_ATTR_NAME);
                if (!"true".equalsIgnoreCase(exclude)) return true;
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "NCLS-CORE-00047", new Object[]{file.getAbsolutePath(), e});
            }
            return true;
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

