/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class PacketVariableHeader {
    private static final Charset charset = Charset.forName("UTF-8");
    private static final ThreadLocal<CharsetDecoder> decoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return charset.newDecoder();
        }
    };
    protected ByteBuffer buffer = null;
    protected boolean bufferDirty = false;
    protected boolean bufferParsed = false;
    protected long transactionID = 0L;
    protected long producerID = 0L;
    protected long deliveryTime = 0L;
    protected int deliveryCount = 0;
    protected String[] stringItems = new String[12];

    public PacketVariableHeader() {
        this.reset();
    }

    public synchronized void setBytes(ByteBuffer buf) {
        this.reset();
        if (buf == null) {
            this.buffer = null;
        } else {
            this.buffer = buf;
            this.buffer.rewind();
        }
        this.bufferParsed = false;
        this.bufferDirty = false;
    }

    public synchronized ByteBuffer getBytes() throws IOException {
        if (this.bufferDirty) {
            this.updateBuffer();
        }
        if (this.buffer == null) {
            return null;
        }
        this.buffer.rewind();
        return this.buffer;
    }

    public synchronized ByteBuffer getBytes2() throws IOException {
        if (this.bufferDirty || this.buffer == null) {
            this.updateBuffer();
        }
        return this.getBytes();
    }

    protected synchronized String getStringField(int field) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (field < 12) {
            return this.stringItems[field];
        }
        return null;
    }

    protected synchronized long getLongField(int field) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 8: {
                return this.transactionID;
            }
            case 9: {
                return this.producerID;
            }
            case 10: {
                return this.deliveryTime;
            }
        }
        return 0L;
    }

    protected synchronized void setStringField(int field, String value) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (field < 12) {
            this.stringItems[field] = value;
            this.bufferDirty = true;
        }
    }

    protected synchronized void setLongField(int field, long value) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 8: {
                this.transactionID = value;
                this.bufferDirty = true;
                break;
            }
            case 9: {
                this.producerID = value;
                this.bufferDirty = true;
                break;
            }
            case 10: {
                this.deliveryTime = value;
                this.bufferDirty = true;
                break;
            }
        }
    }

    protected synchronized int getIntField(int field) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 11: {
                return this.deliveryCount;
            }
        }
        return 0;
    }

    protected synchronized void setIntField(int field, int value) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (field) {
            case 11: {
                this.deliveryCount = value;
                this.bufferDirty = true;
                break;
            }
        }
    }

    protected void reset() {
        for (int n = 0; n < 12; ++n) {
            this.stringItems[n] = null;
        }
        this.transactionID = 0L;
        this.producerID = 0L;
        this.deliveryTime = 0L;
        this.deliveryCount = 0;
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.bufferDirty = false;
        this.bufferParsed = true;
    }

    void parseBuffer() {
        short len = 0;
        if (this.buffer == null) {
            this.bufferParsed = true;
            return;
        }
        this.buffer.rewind();
        short type = this.buffer.getShort();
        while (type != 0) {
            switch (type) {
                case 8: {
                    len = this.buffer.getShort();
                    this.transactionID = this.buffer.getLong();
                    break;
                }
                case 9: {
                    len = this.buffer.getShort();
                    this.producerID = this.buffer.getLong();
                    break;
                }
                case 10: {
                    len = this.buffer.getShort();
                    this.deliveryTime = this.buffer.getLong();
                    break;
                }
                case 11: {
                    len = this.buffer.getShort();
                    this.deliveryCount = this.buffer.getInt();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    len = this.buffer.getShort();
                    int currentLimit = this.buffer.limit();
                    int currentPosition = this.buffer.position();
                    this.buffer.limit(currentPosition + len);
                    try {
                        this.stringItems[type] = decoder.get().decode(this.buffer).toString();
                    }
                    catch (CharacterCodingException e) {
                        System.out.println("Could not decode string " + String.valueOf(e));
                    }
                    this.buffer.limit(currentLimit);
                    break;
                }
                default: {
                    len = this.buffer.getShort();
                    this.buffer.position(this.buffer.position() + len);
                }
            }
            type = this.buffer.getShort();
        }
        this.bufferParsed = true;
    }

    private void updateBuffer() throws IOException {
        byte[] pad = new byte[4];
        byte[] buf = new byte[512];
        JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(buf);
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.transactionID != 0L) {
            this.writeLong(dos, 8, this.transactionID);
        }
        if (this.producerID != 0L) {
            this.writeLong(dos, 9, this.producerID);
        }
        if (this.deliveryTime != 0L) {
            this.writeLong(dos, 10, this.deliveryTime);
        }
        if (this.deliveryCount > 0) {
            this.writeInt(dos, 11, this.deliveryCount);
        }
        for (int n = 0; n < 12; ++n) {
            if (this.stringItems[n] == null) continue;
            this.writeString(dos, n, this.stringItems[n]);
        }
        dos.writeShort(0);
        dos.flush();
        int padding = 4 - bos.getCount() % 4;
        bos.write(pad, 0, padding);
        bos.flush();
        this.buffer = ByteBuffer.wrap(bos.getBuf(), 0, bos.getCount());
        this.bufferDirty = false;
        this.bufferParsed = true;
        bos.close();
        dos.close();
    }

    private void writeString(DataOutputStream dos, int type, String value) throws IOException {
        if (value != null) {
            dos.writeShort(type);
            dos.writeUTF(value);
        }
    }

    private void writeLong(DataOutputStream dos, int type, long value) throws IOException {
        dos.writeShort(type);
        dos.writeShort(8);
        dos.writeLong(value);
    }

    private void writeInt(DataOutputStream dos, int type, int value) throws IOException {
        dos.writeShort(type);
        dos.writeShort(4);
        dos.writeInt(value);
    }
}

