/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ConnectionMetaDataAdapter;
import com.sun.messaging.jmq.jmsservice.JMSService;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class ConnectionMetaData
extends ConnectionMetaDataAdapter {
    protected Properties connectionProps;
    private Vector<String> supportedProperties = new Vector(7);

    public ConnectionMetaData(Properties connectionProps) {
        this.connectionProps = connectionProps;
        this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXGroupID.toString());
        this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXGroupSeq.toString());
        if (this.hasJMSXAppID()) {
            this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXAppID.toString());
        }
        if (this.hasJMSXUserID()) {
            this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXUserID.toString());
        }
        if (this.hasJMSXProducerTXID()) {
            this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXProducerTXID.toString());
        }
        if (this.hasJMSXConsumerTXID()) {
            this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXConsumerTXID.toString());
        }
        if (this.hasJMSXRcvTimestamp()) {
            this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXRcvTimestamp.toString());
        }
        this.supportedProperties.addElement(JMSService.JMSXProperties.JMSXDeliveryCount.toString());
    }

    protected abstract boolean hasJMSXAppID();

    protected abstract boolean hasJMSXUserID();

    protected abstract boolean hasJMSXProducerTXID();

    protected abstract boolean hasJMSXConsumerTXID();

    protected abstract boolean hasJMSXRcvTimestamp();

    public Enumeration getJMSXPropertyNames() throws JMSException {
        return this.supportedProperties.elements();
    }

    public Properties getConnectionProperties() {
        return this.connectionProps;
    }
}

