/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.event.WeldAfterBeanDiscovery;
import org.jboss.weld.bootstrap.event.WeldProcessManagedBean;
import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;
import org.jboss.weld.event.EventMetadataAwareObserverMethod;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.SyntheticObserverMethod;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Bindings;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class Observers {
    public static final Set<Class<?>> CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES = ImmutableSet.of(new Class[]{BeforeBeanDiscovery.class, AfterTypeDiscovery.class, AfterBeanDiscovery.class, AfterDeploymentValidation.class, BeforeShutdown.class, ProcessAnnotatedType.class, ProcessInjectionPoint.class, ProcessInjectionTarget.class, ProcessProducer.class, ProcessBeanAttributes.class, ProcessBean.class, ProcessObserverMethod.class});
    public static final Set<Class<?>> CONTAINER_LIFECYCLE_EVENT_TYPES = ImmutableSet.builder().addAll((Iterable<Class<?>>)CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES).addAll(ProcessSyntheticAnnotatedType.class, ProcessSessionBean.class, ProcessManagedBean.class, ProcessProducerMethod.class, ProcessProducerField.class, ProcessSyntheticBean.class, ProcessSyntheticObserverMethod.class, WeldAfterBeanDiscovery.class, WeldProcessManagedBean.class).build();
    private static final String NOTIFY_METHOD_NAME = "notify";

    private Observers() {
    }

    public static boolean isContainerLifecycleObserverMethod(ObserverMethod<?> method) {
        if (CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(method.getObservedType()))) {
            return true;
        }
        if (Object.class.equals((Object)method.getObservedType()) && method instanceof ContainerLifecycleEventObserverMethod) {
            if (method.getObservedQualifiers().isEmpty()) {
                return true;
            }
            if (method.getObservedQualifiers().size() == 1 && method.getObservedQualifiers().contains(Any.Literal.INSTANCE)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isObserverMethodEnabled(ObserverMethod<?> method, BeanManagerImpl manager) {
        if (method instanceof ObserverMethodImpl) {
            Bean declaringBean = ((ObserverMethodImpl)Reflections.cast(method)).getDeclaringBean();
            return manager.getServices().get(SpecializationAndEnablementRegistry.class).isCandidateForLifecycleEvent(declaringBean);
        }
        return true;
    }

    public static void validateObserverMethod(ObserverMethod<?> observerMethod, BeanManager beanManager, ObserverMethod<?> originalObserverMethod) {
        Set<Annotation> qualifiers = observerMethod.getObservedQualifiers();
        if (observerMethod.getBeanClass() == null) {
            throw EventLogger.LOG.observerMethodsMethodReturnsNull("getBeanClass", observerMethod);
        }
        if (observerMethod.getObservedType() == null) {
            throw EventLogger.LOG.observerMethodsMethodReturnsNull("getObservedType", observerMethod);
        }
        Bindings.validateQualifiers(qualifiers, beanManager, observerMethod, "ObserverMethod.getObservedQualifiers");
        if (observerMethod.getReception() == null) {
            throw EventLogger.LOG.observerMethodsMethodReturnsNull("getReception", observerMethod);
        }
        if (observerMethod.getTransactionPhase() == null) {
            throw EventLogger.LOG.observerMethodsMethodReturnsNull("getTransactionPhase", observerMethod);
        }
        if (originalObserverMethod != null && !observerMethod.getBeanClass().equals(originalObserverMethod.getBeanClass())) {
            throw EventLogger.LOG.beanClassMismatch(originalObserverMethod, observerMethod);
        }
        if (!(observerMethod instanceof SyntheticObserverMethod) && !Observers.hasNotifyOverriden(observerMethod.getClass(), observerMethod)) {
            throw EventLogger.LOG.notifyMethodNotImplemented(observerMethod);
        }
    }

    public static boolean isEventMetadataRequired(ObserverMethod<?> observer) {
        if (observer instanceof EventMetadataAwareObserverMethod) {
            EventMetadataAwareObserverMethod eventMetadataAware = (EventMetadataAwareObserverMethod)observer;
            return eventMetadataAware.isEventMetadataRequired();
        }
        return true;
    }

    public static <T> void notify(ObserverMethod<? super T> observerMethod, T event, EventMetadata metadata) {
        observerMethod.notify(new EventContextImpl<T>(event, metadata));
    }

    private static boolean hasNotifyOverriden(Class<?> clazz, ObserverMethod<?> observerMethod) {
        if (clazz.isInterface()) {
            return false;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!NOTIFY_METHOD_NAME.equals(method.getName()) || method.getParameterCount() != 1) continue;
            return true;
        }
        return clazz.getSuperclass() != null ? Observers.hasNotifyOverriden(clazz.getSuperclass(), observerMethod) : false;
    }

    static class EventContextImpl<T>
    implements EventContext<T> {
        private final T event;
        private final EventMetadata metadata;

        EventContextImpl(T event, EventMetadata metadata) {
            this.event = event;
            this.metadata = metadata;
        }

        @Override
        public T getEvent() {
            return this.event;
        }

        @Override
        public EventMetadata getMetadata() {
            return this.metadata;
        }
    }
}

