/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;

final class ApplicationFilterChain
implements FilterChain {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet;
    private StandardWrapper wrapper;
    private static Class<?>[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.internalDoFilter(request, response);
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.wrapper == null) {
            throw new IllegalStateException("Missing wrapper");
        }
        InstanceSupport support = this.wrapper.getInstanceSupport();
        if (this.pos < this.n) {
            RequestFacadeHelper reqFacHelper;
            ApplicationFilterConfig filterConfig;
            if (!(filterConfig = this.filters[this.pos++]).isAsyncSupported() && (reqFacHelper = RequestFacadeHelper.getInstance(request)) != null) {
                reqFacHelper.disableAsyncSupport();
            }
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                support.fireInstanceEvent(InstanceEvent.EventType.BEFORE_FILTER_EVENT, filter, request, response);
                filter.doFilter(request, response, this);
                support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response);
            }
            catch (ServletException | IOException | RuntimeException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, e);
                }
                throw new ServletException(rb.getString("AS-WEB-CORE-00097"), e);
            }
            return;
        }
        this.wrapper.service(request, response, this.servlet);
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.wrapper = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setWrapper(StandardWrapper wrapper) {
        this.wrapper = wrapper;
    }
}

