/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.glassfish.kernel.event.EventsImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;

public class OSGiAwareEventsImpl
extends EventsImpl
implements FrameworkListener {
    @PostConstruct
    public void addFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            bundleContext.addFrameworkListener((FrameworkListener)this);
        }
    }

    @PreDestroy
    public void removeFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            bundleContext.removeFrameworkListener((FrameworkListener)this);
        }
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        if (frameworkEvent.getType() == 4) {
            BundleContext bundleContext = frameworkEvent.getBundle().getBundleContext();
            this.listeners.keySet().removeIf(listener -> {
                Bundle bundle = FrameworkUtil.getBundle((Class)listener.unwrap().getClass());
                if (bundle != null) {
                    return bundleContext.getBundle(bundle.getBundleId()) == null;
                }
                return true;
            });
        }
    }

    private BundleContext getBundleContext() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        return bundle != null ? bundle.getBundleContext() : null;
    }
}

