/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import java.util.logging.Level;

class TransactedSubscriber
implements StompSubscriber,
MessageListener {
    private String _subid = null;
    private StompTransactedSession _parent = null;
    private MessageConsumer _subscriber = null;
    private String _duraName = null;

    TransactedSubscriber(String subid, MessageConsumer sub, String duraname, StompTransactedSession parent) {
        this._subid = subid;
        this._subscriber = sub;
        this._parent = parent;
        this._duraName = duraname;
    }

    @Override
    public void startDelivery() throws Exception {
        this._subscriber.setMessageListener((MessageListener)this);
    }

    public String getDuraName() {
        return this._duraName;
    }

    public void onMessage(Message msg) {
        try {
            this._parent.logger.log(Level.FINE, "onMessage message " + msg.getJMSMessageID() + " for STOMP subscriber " + this._subid);
            this._parent.enqueue(this._subid, msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void close() throws Exception {
        this._subscriber.close();
    }
}

