/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheIdComparator;

public class CacheId
implements Serializable,
Comparable<CacheId> {
    public static final CacheId EMPTY = new CacheId(new Object[0]);
    private static final CacheIdComparator COMPARATOR = new CacheIdComparator();
    protected Object[] primaryKey;
    protected int hash;
    protected boolean hasArray;

    public CacheId() {
    }

    public CacheId(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public Object[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public void add(Object value) {
        Object[] array = new Object[this.primaryKey.length + 1];
        System.arraycopy(this.primaryKey, 0, array, 0, this.primaryKey.length);
        array[this.primaryKey.length] = value;
        this.setPrimaryKey(array);
    }

    public void set(int index, Object value) {
        this.primaryKey[index] = value;
        this.setPrimaryKey(this.primaryKey);
    }

    protected int computeHash(Object[] primaryKey) {
        int result = 1;
        for (Object value : primaryKey) {
            if (value != null) {
                if (value.getClass().isArray()) {
                    result = this.computeArrayHashCode(result, value);
                    this.hasArray = true;
                    continue;
                }
                result = 31 * result + value.hashCode();
                continue;
            }
            result = 31 * result;
        }
        return result;
    }

    private int computeArrayHashCode(int result, Object obj) {
        if (obj.getClass() == ClassConstants.APBYTE) {
            for (byte element : (byte[])obj) {
                result = 31 * result + element;
            }
        } else if (obj.getClass() == ClassConstants.APCHAR) {
            for (char element : (char[])obj) {
                result = 31 * result + element;
            }
        } else {
            for (Object element : (Object[])obj) {
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
        }
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheId)object);
        }
        catch (ClassCastException incorrectType) {
            return false;
        }
    }

    public boolean equals(CacheId id) {
        if (this == id) {
            return true;
        }
        if (this.hash != id.hash) {
            return false;
        }
        if (this.hasArray != id.hasArray) {
            return false;
        }
        int size = this.primaryKey.length;
        Object[] otherKey = id.primaryKey;
        if (size == otherKey.length) {
            for (int index = 0; index < size; ++index) {
                Object value = this.primaryKey[index];
                Object otherValue = otherKey[index];
                if (value == null) {
                    if (otherValue == null) continue;
                    return false;
                }
                if (otherValue == null) {
                    return false;
                }
                if (this.hasArray) {
                    Class<?> valueClass = value.getClass();
                    if (valueClass.isArray()) {
                        Class<?> otherClass = otherValue.getClass();
                        if (!(valueClass == ClassConstants.APBYTE && otherClass == ClassConstants.APBYTE ? !Helper.compareByteArrays((byte[])value, (byte[])otherValue) : (valueClass == ClassConstants.APCHAR && otherClass == ClassConstants.APCHAR ? !Helper.compareCharArrays((char[])value, (char[])otherValue) : !Helper.compareArrays((Object[])value, (Object[])otherValue)))) continue;
                        return false;
                    }
                    if (value.equals(otherValue)) continue;
                    return false;
                }
                if (value.equals(otherValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CacheId otherId) {
        return COMPARATOR.compare(this, otherId);
    }

    public boolean hasArray() {
        return this.hasArray;
    }

    public String toString() {
        return "[" + String.valueOf(Arrays.asList(this.primaryKey)) + ": " + this.hash + "]";
    }
}

