/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;

public abstract class AbstractDataProvider
implements DataProvider,
Serializable {
    protected FieldKey[] fieldKeys = FieldKey.EMPTY_ARRAY;
    protected DataListener[] dpListeners = null;

    public abstract Class getType(FieldKey var1) throws DataProviderException;

    public abstract boolean isReadOnly(FieldKey var1) throws DataProviderException;

    public abstract Object getValue(FieldKey var1) throws DataProviderException;

    public abstract void setValue(FieldKey var1, Object var2) throws DataProviderException;

    public Class getType(String fieldId) throws DataProviderException {
        return this.getType(this.getFieldKey(fieldId));
    }

    public boolean isReadOnly(String fieldId) throws DataProviderException {
        return this.isReadOnly(this.getFieldKey(fieldId));
    }

    public Object getValue(String fieldId) throws DataProviderException {
        return this.getValue(this.getFieldKey(fieldId));
    }

    public void setValue(String fieldId, Object value) throws DataProviderException {
        this.setValue(this.getFieldKey(fieldId), value);
    }

    protected void addFieldKey(FieldKey fieldKey) {
        if (this.fieldKeys == null) {
            this.fieldKeys = new FieldKey[1];
            this.fieldKeys[0] = fieldKey;
            return;
        }
        FieldKey[] results = new FieldKey[this.fieldKeys.length + 1];
        System.arraycopy(this.fieldKeys, 0, results, 0, this.fieldKeys.length);
        results[results.length - 1] = fieldKey;
        this.fieldKeys = results;
        this.fireProviderChanged();
    }

    protected void addFieldKeys(FieldKey[] fieldKeys) {
        for (int i = 0; i < fieldKeys.length; ++i) {
            this.addFieldKey(fieldKeys[i]);
        }
        this.fireProviderChanged();
    }

    protected void sortFieldKeys() {
        Arrays.sort(this.fieldKeys);
    }

    protected void removeFieldKey(FieldKey fieldKey) {
        if (this.fieldKeys == null) {
            return;
        }
        ArrayList<FieldKey> list = new ArrayList<FieldKey>(this.fieldKeys.length - 1);
        for (int i = 0; i < this.fieldKeys.length; ++i) {
            if (this.fieldKeys[i] == fieldKey || this.fieldKeys[i].equals(fieldKey)) continue;
            list.add(this.fieldKeys[i]);
        }
        this.fieldKeys = list.toArray(new FieldKey[list.size() - 1]);
        this.fireProviderChanged();
    }

    protected void removeFieldKeys(FieldKey[] fieldKeys) {
        for (int i = 0; i < fieldKeys.length; ++i) {
            this.removeFieldKey(fieldKeys[i]);
        }
        this.fireProviderChanged();
    }

    protected void clearFieldKeys() {
        this.fieldKeys = FieldKey.EMPTY_ARRAY;
        this.fireProviderChanged();
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        return this.fieldKeys;
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        for (int i = 0; this.fieldKeys != null && i < this.fieldKeys.length; ++i) {
            FieldKey fk = this.fieldKeys[i];
            if (fieldId != fk.getFieldId() && !fieldId.equals(fk.getFieldId())) continue;
            return fk;
        }
        return null;
    }

    public static Object getFakeData(Class dataType) {
        return AbstractDataProvider.getFakeData(dataType, null);
    }

    public static Object getFakeData(Class dataType, Class collectionElementType) {
        return AbstractDataProvider.getFakeData(dataType, collectionElementType, new ArrayList());
    }

    private static Object getFakeData(Class dataType, Class collectionElementType, ArrayList recurseCheckClassList) {
        block41: {
            if (dataType == null || Void.TYPE == dataType) {
                return null;
            }
            if (dataType.isArray()) {
                collectionElementType = dataType.getComponentType();
                Object[] result = new Object[3];
                for (int i = 0; i < result.length; ++i) {
                    if (recurseCheckClassList.contains(collectionElementType)) continue;
                    recurseCheckClassList.add(collectionElementType);
                    result[i] = AbstractDataProvider.getFakeData(collectionElementType, null, recurseCheckClassList);
                    recurseCheckClassList.remove(collectionElementType);
                }
                return result;
            }
            if (Collection.class.isAssignableFrom(dataType)) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (int i = 0; i < 3; ++i) {
                    if (!recurseCheckClassList.contains(collectionElementType)) {
                        recurseCheckClassList.add(collectionElementType);
                        result.add(AbstractDataProvider.getFakeData(collectionElementType, null, recurseCheckClassList));
                        recurseCheckClassList.remove(collectionElementType);
                        continue;
                    }
                    result.add(null);
                }
                return result;
            }
            if (dataType.isPrimitive()) {
                if (Boolean.TYPE == dataType) {
                    return Boolean.TRUE;
                }
                if (Character.TYPE == dataType) {
                    return new Character('a');
                }
                if (Byte.TYPE == dataType) {
                    return new Byte(123);
                }
                if (Short.TYPE == dataType) {
                    return new Short(123);
                }
                if (Integer.TYPE == dataType) {
                    return new Integer(123);
                }
                if (Long.TYPE == dataType) {
                    return new Long(123L);
                }
                if (Float.TYPE == dataType) {
                    return new Float(123.45);
                }
                if (Double.TYPE == dataType) {
                    return new Double(123.45);
                }
            } else {
                if (Boolean.class == dataType) {
                    return Boolean.TRUE;
                }
                if (java.util.Date.class == dataType) {
                    return new java.util.Date();
                }
                if (Date.class == dataType) {
                    return new Date(System.currentTimeMillis());
                }
                if (Calendar.class == dataType) {
                    return new GregorianCalendar();
                }
                if (BigDecimal.class == dataType) {
                    return new BigDecimal(123.0);
                }
                if (BigInteger.class == dataType) {
                    return BigInteger.valueOf(123L);
                }
                if (Character.class == dataType) {
                    return new Character('a');
                }
                if (Byte.class == dataType) {
                    return new Byte(123);
                }
                if (Short.class == dataType) {
                    return new Short(123);
                }
                if (Integer.class == dataType) {
                    return new Integer(123);
                }
                if (Long.class == dataType) {
                    return new Long(123L);
                }
                if (Float.class == dataType) {
                    return new Float(123.45);
                }
                if (Double.class == dataType) {
                    return new Double(123.45);
                }
                if (String.class == dataType) {
                    return "abc";
                }
                try {
                    Constructor con = dataType.getConstructor(new Class[0]);
                    if (con == null) break block41;
                    Object o = con.newInstance(new Object[0]);
                    if (o != null) {
                        try {
                            BeanInfo bi = Introspector.getBeanInfo(o.getClass(), 3);
                            PropertyDescriptor[] props = bi.getPropertyDescriptors();
                            for (int i = 0; props != null && i < props.length; ++i) {
                                Class<?> propType;
                                if (props[i].getWriteMethod() == null || props[i].getReadMethod() == null || recurseCheckClassList.contains(propType = props[i].getPropertyType())) continue;
                                recurseCheckClassList.add(propType);
                                Object data = AbstractDataProvider.getFakeData(propType, null, recurseCheckClassList);
                                recurseCheckClassList.remove(propType);
                                try {
                                    props[i].getWriteMethod().invoke(o, data);
                                    continue;
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        Field[] fields = o.getClass().getFields();
                        for (int i = 0; fields != null && i < fields.length; ++i) {
                            Class<?> fieldType;
                            if (!Modifier.isPublic(fields[i].getModifiers()) || recurseCheckClassList.contains(fieldType = fields[i].getType())) continue;
                            recurseCheckClassList.add(fieldType);
                            Object data = AbstractDataProvider.getFakeData(fieldType, null, recurseCheckClassList);
                            recurseCheckClassList.remove(fieldType);
                            try {
                                fields[i].set(o, data);
                                continue;
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                    }
                    return o;
                }
                catch (Exception x) {
                    return null;
                }
            }
        }
        return null;
    }

    public void addDataListener(DataListener listener) {
        if (this.dpListeners == null) {
            this.dpListeners = new DataListener[1];
            this.dpListeners[0] = listener;
            return;
        }
        DataListener[] results = new DataListener[this.dpListeners.length + 1];
        System.arraycopy(this.dpListeners, 0, results, 0, this.dpListeners.length);
        results[results.length - 1] = listener;
        this.dpListeners = results;
    }

    public void removeDataListener(DataListener listener) {
        if (this.dpListeners == null) {
            return;
        }
        ArrayList<DataListener> list = new ArrayList<DataListener>(this.dpListeners.length - 1);
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (this.dpListeners[i] == listener) continue;
            list.add(this.dpListeners[i]);
        }
        this.dpListeners = list.size() < 1 ? null : list.toArray(new DataListener[list.size()]);
    }

    public DataListener[] getDataListeners() {
        if (this.dpListeners == null) {
            return new DataListener[0];
        }
        return this.dpListeners;
    }

    protected void fireValueChanged(FieldKey fieldKey, Object oldValue, Object newValue) {
        DataListener[] dpls = this.getDataListeners();
        for (int i = 0; i < dpls.length; ++i) {
            dpls[i].valueChanged(this, fieldKey, oldValue, newValue);
        }
    }

    protected void fireProviderChanged() {
        DataListener[] dpls = this.getDataListeners();
        for (int i = 0; i < dpls.length; ++i) {
            dpls[i].providerChanged(this);
        }
    }
}

