/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogHelper {
    public static void log(Logger logger, Level level, String messageId, Throwable thrown, Object ... params) {
        LogRecord rec = new LogRecord(level, messageId);
        rec.setLoggerName(logger.getName());
        rec.setResourceBundleName(logger.getResourceBundleName());
        rec.setResourceBundle(logger.getResourceBundle());
        rec.setParameters(params);
        rec.setThrown(thrown);
        logger.log(rec);
    }

    public static String getFormattedMessage(Logger logger, String msgKey, Object ... params) {
        ResourceBundle rb = logger.getResourceBundle();
        if (rb != null) {
            try {
                return MessageFormat.format(rb.getString(msgKey), params);
            }
            catch (MissingResourceException e) {
                return msgKey;
            }
        }
        return msgKey;
    }
}

