/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.CleanerFactory;
import org.glassfish.hk2.utilities.general.Hk2ThreadLocal;
import org.glassfish.hk2.utilities.reflection.Logger;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class PerThreadContext
implements Context<PerThread> {
    private static final boolean LOG_THREAD_DESTRUCTION = AccessController.doPrivileged(() -> Boolean.getBoolean("org.hk2.debug.perthreadcontext.log"));
    private final Hk2ThreadLocal<PerThreadContextWrapper> threadMap = new Hk2ThreadLocal<PerThreadContextWrapper>(){

        public PerThreadContextWrapper initialValue() {
            return new PerThreadContextWrapper();
        }
    };

    @Override
    public Class<? extends Annotation> getScope() {
        return PerThread.class;
    }

    @Override
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Object retVal = ((PerThreadContextWrapper)this.threadMap.get()).get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            ((PerThreadContextWrapper)this.threadMap.get()).put(activeDescriptor, retVal);
        }
        return (U)retVal;
    }

    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        return ((PerThreadContextWrapper)this.threadMap.get()).has(descriptor);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean supportsNullCreation() {
        return false;
    }

    @Override
    public void shutdown() {
        this.threadMap.removeAll();
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
    }

    private static class PerThreadContextWrapper {
        private final CleanableContext context = new CleanableContext();

        public PerThreadContextWrapper() {
            this.registerStopEvent();
        }

        public boolean has(ActiveDescriptor<?> descriptor) {
            return this.context.has(descriptor);
        }

        public Object get(ActiveDescriptor<?> descriptor) {
            return this.context.get(descriptor);
        }

        public void put(ActiveDescriptor<?> descriptor, Object value) {
            this.context.put(descriptor, value);
        }

        public final void registerStopEvent() {
            CleanerFactory.create().register(this, this.context);
        }
    }

    private static final class CleanableContext
    implements Runnable {
        private final Map<ActiveDescriptor<?>, Object> instances = new HashMap();
        private final long id = Thread.currentThread().getId();

        private CleanableContext() {
        }

        public boolean has(ActiveDescriptor<?> descriptor) {
            return this.instances.containsKey(descriptor);
        }

        public Object get(ActiveDescriptor<?> descriptor) {
            return this.instances.get(descriptor);
        }

        public void put(ActiveDescriptor<?> descriptor, Object value) {
            this.instances.put(descriptor, value);
        }

        @Override
        public void run() {
            this.instances.clear();
            if (LOG_THREAD_DESTRUCTION) {
                Logger.getLogger().debug("Removing PerThreadContext data for thread " + this.id);
            }
        }
    }
}

