/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Principal;

public class TCPConnectionImpl
implements WebServiceContextDelegate {
    private final ChannelContext channelContext;
    private final Connection connection;
    private String contentType;
    private int replyStatus;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean isHeaderSerialized;

    public TCPConnectionImpl(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.connection = channelContext.getConnection();
    }

    public InputStream openInput() throws IOException, WSTCPException {
        this.inputStream = this.connection.openInputStream();
        this.contentType = this.channelContext.getContentType();
        return this.inputStream;
    }

    public OutputStream openOutput() throws IOException, WSTCPException {
        this.setMessageHeaders();
        this.outputStream = this.connection.openOutputStream();
        return this.outputStream;
    }

    public int getStatus() {
        return this.replyStatus;
    }

    public void setStatus(int statusCode) {
        this.replyStatus = statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void flush() throws IOException, WSTCPException {
        if (this.outputStream == null) {
            this.setMessageHeaders();
            this.outputStream = this.connection.openOutputStream();
        }
        this.connection.flush();
    }

    public void close() {
    }

    @Override
    public Principal getUserPrincipal(Packet request) {
        return null;
    }

    @Override
    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    @Override
    @NotNull
    public String getEPRAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        return this.channelContext.getTargetWSURI().toString();
    }

    @Override
    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        return null;
    }

    public void sendErrorMessage(WSTCPError message) throws IOException, WSTCPException {
        this.setStatus(2);
        OutputStream output = this.openOutput();
        String description = message.getDescription();
        DataInOutUtils.writeInts4(output, message.getCode(), message.getSubCode(), description.length());
        output.write(description.getBytes(StandardCharsets.UTF_8));
        this.flush();
    }

    private void setMessageHeaders() throws WSTCPException {
        if (!this.isHeaderSerialized) {
            this.isHeaderSerialized = true;
            int messageId = this.getMessageId();
            this.connection.setMessageId(messageId);
            if (FrameType.isFrameContainsParams(messageId)) {
                this.channelContext.setContentType(this.contentType);
            }
        }
    }

    private int getMessageId() {
        if (this.getStatus() == 1) {
            return 5;
        }
        if (this.getStatus() != 0) {
            return 4;
        }
        return 0;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }
}

