/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;

public class XMLPlatformFactory {
    public static final String XML_PLATFORM_PROPERTY = "eclipselink.xml.platform";
    public static final String XDK_PLATFORM_CLASS_NAME = "org.eclipse.persistence.platform.xml.xdk.XDKPlatform";
    public static final String JAXP_PLATFORM_CLASS_NAME = "org.eclipse.persistence.platform.xml.jaxp.JAXPPlatform";
    private static XMLPlatformFactory instance;
    private Class<? extends XMLPlatform> xmlPlatformClass;

    private XMLPlatformFactory() {
    }

    public static XMLPlatformFactory getInstance() throws XMLPlatformException {
        if (null == instance) {
            instance = new XMLPlatformFactory();
        }
        return instance;
    }

    public Class<? extends XMLPlatform> getXMLPlatformClass() throws XMLPlatformException {
        if (null != this.xmlPlatformClass) {
            return this.xmlPlatformClass;
        }
        String newXMLPlatformClassName = PrivilegedAccessHelper.getSystemProperty(XML_PLATFORM_PROPERTY);
        if (null == newXMLPlatformClassName) {
            newXMLPlatformClassName = JAXP_PLATFORM_CLASS_NAME;
        }
        try {
            ClassLoader classLoader = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    classLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(this.getClass()));
                }
                catch (PrivilegedActionException ex) {
                    throw (RuntimeException)ex.getCause();
                }
            } else {
                classLoader = PrivilegedAccessHelper.getClassLoaderForClass(this.getClass());
            }
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> newXMLPlatformClass = classLoader.loadClass(newXMLPlatformClassName);
            this.setXMLPlatformClass(newXMLPlatformClass);
            return this.xmlPlatformClass;
        }
        catch (ClassNotFoundException e) {
            throw XMLPlatformException.xmlPlatformClassNotFound(newXMLPlatformClassName, e);
        }
    }

    public void setXMLPlatformClass(Class<? extends XMLPlatform> xmlPlatformClass) {
        this.xmlPlatformClass = xmlPlatformClass;
    }

    public XMLPlatform getXMLPlatform() throws XMLPlatformException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass<XMLPlatform>(this.getXMLPlatformClass()));
                }
                catch (PrivilegedActionException ex) {
                    throw (RuntimeException)ex.getCause();
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getXMLPlatformClass());
        }
        catch (ReflectiveOperationException e) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), e);
        }
    }
}

