/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.jboss.jdeparser.AbstractJCall;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.AllowedStatementExpression;
import org.jboss.jdeparser.AssertMessageJStatement;
import org.jboss.jdeparser.AssignmentJExpr;
import org.jboss.jdeparser.BasicJCommentable;
import org.jboss.jdeparser.BlankLine;
import org.jboss.jdeparser.BlockContent;
import org.jboss.jdeparser.DirectJCall;
import org.jboss.jdeparser.DoJBlock;
import org.jboss.jdeparser.EmptyJStatement;
import org.jboss.jdeparser.ExpressionJStatement;
import org.jboss.jdeparser.FirstJVarDeclaration;
import org.jboss.jdeparser.ForEachJBlock;
import org.jboss.jdeparser.ForJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.GotoJStatement;
import org.jboss.jdeparser.ImplJAnonymousClassDef;
import org.jboss.jdeparser.ImplJIf;
import org.jboss.jdeparser.ImplJLabel;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.ImplJSwitch;
import org.jboss.jdeparser.ImplJTry;
import org.jboss.jdeparser.IncDecJExpr;
import org.jboss.jdeparser.InstanceJCall;
import org.jboss.jdeparser.JAnonymousClassDef;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JFor;
import org.jboss.jdeparser.JIf;
import org.jboss.jdeparser.JLabel;
import org.jboss.jdeparser.JStatement;
import org.jboss.jdeparser.JSwitch;
import org.jboss.jdeparser.JTry;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.KeywordExprJStatement;
import org.jboss.jdeparser.KeywordJCall;
import org.jboss.jdeparser.KeywordJStatement;
import org.jboss.jdeparser.NameJExpr;
import org.jboss.jdeparser.NewJCall;
import org.jboss.jdeparser.PlainJArrayExpr;
import org.jboss.jdeparser.PlainJClassDef;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticJCall;
import org.jboss.jdeparser.SynchJBlock;
import org.jboss.jdeparser.Tokens$;
import org.jboss.jdeparser.WhileJBlock;

class BasicJBlock
extends BasicJCommentable
implements JBlock,
BlockContent {
    private final BasicJBlock parent;
    private final ArrayList<BlockContent> content = new ArrayList();
    private final JBlock.Braces braces;
    private int tmpId = 1;

    BasicJBlock(BasicJBlock parent, JBlock.Braces braces) {
        this.parent = parent;
        this.braces = braces;
    }

    private <T extends BlockContent> T add(T s) {
        this.content.add(s);
        return s;
    }

    private <T extends AbstractJExpr> ExpressionJStatement add(T item) {
        ExpressionJStatement statement = new ExpressionJStatement(item);
        this.content.add(statement);
        return statement;
    }

    private <T extends AbstractJCall> T add(T item) {
        this.content.add(new ExpressionJStatement(item));
        return item;
    }

    @Override
    public JBlock blankLine() {
        this.add(BlankLine.getInstance());
        return this;
    }

    @Override
    public JBlock block(JBlock.Braces braces) {
        return this.add(new BasicJBlock(this, braces));
    }

    @Override
    public JIf _if(JExpr cond) {
        return this.add(new ImplJIf(this, cond));
    }

    @Override
    public JBlock _while(JExpr cond) {
        return this.add(new WhileJBlock(this, cond));
    }

    @Override
    public JBlock _do(JExpr cond) {
        return this.add(new DoJBlock(this, cond));
    }

    @Override
    public JLabel label(String name) {
        return this.add(new ImplJLabel(name));
    }

    @Override
    public JLabel anonLabel() {
        return this.add(new ImplJLabel(this.tempName()));
    }

    @Override
    public JLabel forwardLabel() {
        return new ImplJLabel();
    }

    @Override
    public JLabel label(JLabel label, String name) {
        ImplJLabel label1 = (ImplJLabel)label;
        if (label1.isResolved()) {
            throw new IllegalStateException("Label " + label + " is already resolved");
        }
        label1.setName(name);
        return this.add(label1);
    }

    @Override
    public JLabel anonLabel(JLabel label) {
        ImplJLabel label1 = (ImplJLabel)label;
        if (label1.isResolved()) {
            throw new IllegalStateException("Label " + label + " is already resolved");
        }
        label1.setName(this.tempName());
        return this.add(label1);
    }

    @Override
    public JStatement _continue() {
        return this.add(new KeywordJStatement(Tokens$.KW.CONTINUE));
    }

    @Override
    public JStatement _continue(JLabel label) {
        return this.add(new GotoJStatement(Tokens$.KW.CONTINUE, label));
    }

    @Override
    public JStatement _break() {
        return this.add(new KeywordJStatement(Tokens$.KW.BREAK));
    }

    @Override
    public JStatement _break(JLabel label) {
        return this.add(new GotoJStatement(Tokens$.KW.BREAK, label));
    }

    @Override
    public JBlock forEach(int mods, String type, String name, JExpr iterable) {
        return this.forEach(mods, JTypes.typeNamed(type), name, iterable);
    }

    @Override
    public JBlock forEach(int mods, JType type, String name, JExpr iterable) {
        return this.add(new ForEachJBlock(this, mods, type, name, iterable));
    }

    @Override
    public JBlock forEach(int mods, Class<?> type, String name, JExpr iterable) {
        return this.forEach(mods, JTypes.typeOf(type), name, iterable);
    }

    @Override
    public JFor _for() {
        return this.add(new ForJBlock(this));
    }

    @Override
    public JSwitch _switch(JExpr expr) {
        return this.add(new ImplJSwitch(this.parent, expr));
    }

    @Override
    public JStatement _return(JExpr expr) {
        return this.add(new KeywordExprJStatement(Tokens$.KW.RETURN, expr));
    }

    @Override
    public JStatement _return() {
        return this.add(new KeywordJStatement(Tokens$.KW.RETURN));
    }

    @Override
    public JStatement _assert(JExpr expr) {
        return this.add(new KeywordExprJStatement(Tokens$.KW.ASSERT, expr));
    }

    @Override
    public JStatement _assert(JExpr expr, JExpr message) {
        return this.add(new AssertMessageJStatement(expr, message));
    }

    @Override
    public JCall callThis() {
        return this.add((AbstractJCall)new KeywordJCall(Tokens$.KW.THIS));
    }

    @Override
    public JCall callSuper() {
        return this.add((AbstractJCall)new KeywordJCall(Tokens$.KW.SUPER));
    }

    @Override
    public JStatement add(JExpr expr) {
        if (expr instanceof AllowedStatementExpression) {
            return this.add(new ExpressionJStatement(AbstractJExpr.of(expr)));
        }
        throw new IllegalArgumentException("Expression <<" + expr + ">> is not a valid statement");
    }

    @Override
    public JCall call(ExecutableElement element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.METHOD) {
            String name = element.getSimpleName().toString();
            return this.call(name);
        }
        throw new IllegalArgumentException("Unsupported element for call: " + element);
    }

    @Override
    public JCall call(JExpr obj, ExecutableElement element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.METHOD) {
            String name = element.getSimpleName().toString();
            return this.call(obj, name);
        }
        throw new IllegalArgumentException("Unsupported element for call: " + element);
    }

    @Override
    public JCall call(String name) {
        return this.add((AbstractJCall)new DirectJCall(name));
    }

    @Override
    public JCall call(JExpr obj, String name) {
        return this.add((AbstractJCall)new InstanceJCall(AbstractJExpr.of(obj), name));
    }

    @Override
    public JCall callStatic(ExecutableElement element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.METHOD && element.getModifiers().contains((Object)Modifier.STATIC)) {
            String name = element.getSimpleName().toString();
            JType enclosingType = JTypes.typeOf(element.getEnclosingElement().asType());
            return this.callStatic(enclosingType, name);
        }
        throw new IllegalArgumentException("Unsupported element for callStatic: " + element);
    }

    @Override
    public JCall callStatic(String type, String name) {
        return this.callStatic(JTypes.typeNamed(type), name);
    }

    @Override
    public JCall callStatic(JType type, String name) {
        return this.add((AbstractJCall)new StaticJCall(AbstractJType.of(type), name));
    }

    @Override
    public JCall callStatic(Class<?> type, String name) {
        return this.callStatic(JTypes.typeOf(type), name);
    }

    @Override
    public JCall _new(String type) {
        return this._new(JTypes.typeNamed(type));
    }

    @Override
    public JCall _new(JType type) {
        return this.add((AbstractJCall)new NewJCall(AbstractJType.of(type)));
    }

    @Override
    public JCall _new(Class<?> type) {
        return this._new(JTypes.typeOf(type));
    }

    @Override
    public JAnonymousClassDef _newAnon(String type) {
        return this._newAnon(JTypes.typeNamed(type));
    }

    @Override
    public JAnonymousClassDef _newAnon(JType type) {
        return this.add((AbstractJCall)new ImplJAnonymousClassDef(type));
    }

    @Override
    public JAnonymousClassDef _newAnon(Class<?> type) {
        return this._newAnon(JTypes.typeOf(type));
    }

    @Override
    public JClassDef _class(int mods, String name) {
        return this.add(new PlainJClassDef(mods, (ImplJSourceFile)null, name));
    }

    @Override
    public JBlock _synchronized(JExpr synchExpr) {
        return this.add(new SynchJBlock(this, PlainJArrayExpr.of(synchExpr)));
    }

    @Override
    public JStatement assign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement addAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_PLUS, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement subAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_MINUS, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement mulAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_TIMES, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement divAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_DIV, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement modAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_MOD, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement andAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_BAND, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement orAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_BOR, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement xorAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_BXOR, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement shrAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_SHR, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement lshrAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_LSHR, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement shlAssign(JAssignableExpr target, JExpr e1) {
        return this.add((AbstractJCall)((Object)new AssignmentJExpr(Tokens$.PUNCT.BINOP.ASSIGN_SHL, AbstractJExpr.of(target), AbstractJExpr.of(e1))));
    }

    @Override
    public JStatement postInc(JAssignableExpr target) {
        return this.add((AbstractJCall)((Object)new IncDecJExpr(Tokens$.PUNCT.UNOP.PP, AbstractJExpr.of(target), 1, true)));
    }

    @Override
    public JStatement postDec(JAssignableExpr target) {
        return this.add((AbstractJCall)((Object)new IncDecJExpr(Tokens$.PUNCT.UNOP.MM, AbstractJExpr.of(target), 1, true)));
    }

    @Override
    public JStatement preInc(JAssignableExpr target) {
        return this.add((AbstractJCall)((Object)new IncDecJExpr(Tokens$.PUNCT.UNOP.PP, AbstractJExpr.of(target), 2, false)));
    }

    @Override
    public JStatement preDec(JAssignableExpr target) {
        return this.add((AbstractJCall)((Object)new IncDecJExpr(Tokens$.PUNCT.UNOP.MM, AbstractJExpr.of(target), 2, false)));
    }

    @Override
    public JStatement empty() {
        return this.add(new EmptyJStatement());
    }

    @Override
    public JStatement _throw(JExpr expr) {
        return this.add(new KeywordExprJStatement(Tokens$.KW.THROW, expr));
    }

    @Override
    public JTry _try() {
        return this.add(new ImplJTry(this));
    }

    @Override
    public JVarDeclaration var(int mods, String type, String name, JExpr value) {
        return this.var(mods, JTypes.typeNamed(type), name, value);
    }

    @Override
    public JVarDeclaration var(int mods, JType type, String name, JExpr value) {
        return this.add(new FirstJVarDeclaration(mods, type, name, value));
    }

    @Override
    public JVarDeclaration var(int mods, Class<?> type, String name, JExpr value) {
        return this.var(mods, JTypes.typeOf(type), name, value);
    }

    @Override
    public JVarDeclaration var(int mods, String type, String name) {
        return this.var(mods, JTypes.typeNamed(type), name);
    }

    @Override
    public JVarDeclaration var(int mods, JType type, String name) {
        return this.add(new FirstJVarDeclaration(mods, type, name, null));
    }

    @Override
    public JVarDeclaration var(int mods, Class<?> type, String name) {
        return this.var(mods, JTypes.typeOf(type), name);
    }

    @Override
    public JExpr tempVar(String type, JExpr value) {
        return this.tempVar(JTypes.typeNamed(type), value);
    }

    @Override
    public JExpr tempVar(JType type, JExpr value) {
        String name = this.tempName();
        NameJExpr expr = new NameJExpr(name);
        this.var(0, type, name, value);
        return expr;
    }

    @Override
    public JExpr tempVar(Class<?> type, JExpr value) {
        return this.tempVar(JTypes.typeOf(type), value);
    }

    @Override
    public String tempName() {
        BasicJBlock parent = this.getParent();
        return parent != null ? parent.tempName() : "anon$$$" + this.tmpId++;
    }

    BasicJBlock getParent() {
        return this.parent;
    }

    int size() {
        return this.content.size();
    }

    BlockContent get(int idx) {
        return this.content.get(idx);
    }

    void write(SourceFileWriter writer, FormatPreferences.Space beforeBrace) throws IOException {
        this.write(writer, beforeBrace, this.braces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(SourceFileWriter writer, FormatPreferences.Space beforeBrace, JBlock.Braces braces) throws IOException {
        if (braces == JBlock.Braces.REQUIRED || braces == JBlock.Braces.IF_MULTILINE && this.content.size() != 1) {
            writer.write(beforeBrace);
            writer.write(Tokens$.PUNCT.BRACE.OPEN);
            writer.pushIndent(FormatPreferences.Indentation.LINE);
            try {
                Iterator<BlockContent> iterator = this.content.iterator();
                if (iterator.hasNext()) {
                    writer.write(FormatPreferences.Space.WITHIN_BRACES_CODE);
                    if (iterator.hasNext()) {
                        BlockContent statement = iterator.next();
                        statement.write(writer);
                        while (iterator.hasNext()) {
                            writer.nl();
                            statement = iterator.next();
                            statement.write(writer);
                        }
                    }
                    writer.write(FormatPreferences.Space.WITHIN_BRACES_CODE);
                } else {
                    writer.write(FormatPreferences.Space.WITHIN_BRACES_EMPTY);
                }
            }
            finally {
                writer.popIndent(FormatPreferences.Indentation.LINE);
            }
            writer.write(Tokens$.PUNCT.BRACE.CLOSE);
        } else {
            Iterator<BlockContent> iterator = this.content.iterator();
            if (iterator.hasNext()) {
                iterator.next().write(writer);
                while (iterator.hasNext()) {
                    writer.nl();
                    iterator.next().write(writer);
                }
            }
        }
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        this.write(writer, FormatPreferences.Space.BEFORE_BRACE);
    }

    boolean hasSingleItemOfType(Class<? extends BlockContent> type) {
        return this.size() == 1 && type.isInstance(this.get(0));
    }
}

