/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.cdi;

import com.ibm.jbatch.container.cdi.BatchProducerBean;
import com.ibm.jbatch.container.cdi.JobOpProducerBean;
import jakarta.batch.operations.JobOperator;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchCDIInjectionExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(BatchCDIInjectionExtension.class.getName());
    private Boolean foundJobOp = false;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        logger.log(Level.FINE, "BatchCDIInjectionExtension.beforeBeanDiscovery() bm=" + bm);
        AnnotatedType at = bm.createAnnotatedType(BatchProducerBean.class);
        bbd.addAnnotatedType(at, "JBatch " + BatchProducerBean.class.getName());
        logger.log(Level.FINE, "BatchCDIInjectionExtension.beforeBeanDiscovery() added annotated type: " + BatchProducerBean.class.getName());
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (!this.foundJobOp.booleanValue() && processBeanEvent.getBean().getTypes().contains(JobOperator.class)) {
            if (processBeanEvent.getBean().getBeanClass().equals(JobOpProducerBean.class)) {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() detecting our own JobOpProducerBean");
            } else {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() Found JobOperator of class: " + processBeanEvent.getBean().getBeanClass());
                this.foundJobOp = true;
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.foundJobOp.booleanValue()) {
            logger.log(Level.FINE, "Deferring to other detected JobOperator Bean");
            return;
        }
        logger.log(Level.FINE, "Didn't find JobOperator Bean, registering JBatch one");
        abd.addBean((Bean)new JobOpProducerBean(bm));
    }
}

