/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropSequenceNode
extends DDLStatementNode {
    private TableName dropItem;

    DropSequenceNode(TableName tableName, ContextManager contextManager) {
        super(tableName, contextManager);
        this.dropItem = tableName;
    }

    @Override
    public String statementToString() {
        return "DROP ".concat(this.dropItem.getTableName());
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.getRelativeName();
        SequenceDescriptor sequenceDescriptor = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            sequenceDescriptor = dataDictionary.getSequenceDescriptor(schemaDescriptor, string);
        }
        if (sequenceDescriptor == null) {
            throw StandardException.newException("42Y55", this.statementToString(), string);
        }
        this.getCompilerContext().createDependency(sequenceDescriptor);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSequenceConstantAction(this.getSchemaDescriptor(), this.getRelativeName());
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.dropItem != null) {
            this.dropItem = (TableName)this.dropItem.accept(visitor);
        }
    }
}

