/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.cdo.migration.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.edapt.cdo.migration.execution.CDOMigrationReconstructor;
import org.eclipse.emf.edapt.cdo.migration.execution.CDOPersistency;
import org.eclipse.emf.edapt.cdo.migration.execution.EdaptCDOViewProvider;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.common.ResourceSetFactoryImpl;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.IReconstructor;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.declaration.OperationRegistry;
import org.eclipse.emf.edapt.internal.migration.BackupUtils;
import org.eclipse.emf.edapt.internal.migration.MaterializingBackwardConverter;
import org.eclipse.emf.edapt.internal.migration.PrintStreamProgressMonitor;
import org.eclipse.emf.edapt.internal.migration.execution.ClassLoaderFacade;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.MigratorCommandLine;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.WrappedMigrationException;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMigrator {
    private History history;
    private HashMap<String, java.util.Set<Release>> releaseMap;
    private final IClassLoader classLoader;
    private IResourceSetFactory resourceSetFactory = new ResourceSetFactoryImpl();
    private ValidationLevel level = ValidationLevel.CUSTOM_MIGRATION;
    private MetamodelExtent extent;
    private EdaptCDOViewProvider edaptCDOViewProvider;

    public CDOMigrator(URI historyURI, IClassLoader classLoader) throws MigrationException {
        HistoryPackage.eINSTANCE.getHistory();
        try {
            this.history = (History)ResourceUtils.loadElement((URI)historyURI);
        }
        catch (IOException e) {
            throw new MigrationException("History could not be loaded", (Throwable)e);
        }
        this.classLoader = classLoader;
        this.init();
    }

    public CDOMigrator(History history, IClassLoader classLoader) {
        this.history = history;
        this.classLoader = classLoader;
        this.registerCDOResourceFactory();
        CDOViewProviderRegistry vpRegistry = CDOViewProviderRegistry.INSTANCE;
        this.edaptCDOViewProvider = new EdaptCDOViewProvider("cdo(\\.net4j\\.tcp)?://.*", 500);
        vpRegistry.addViewProvider((CDOViewProvider)this.edaptCDOViewProvider);
        this.init();
    }

    private void registerCDOResourceFactory() {
        Map map = Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap();
        if (!map.containsKey("cdo.net4j.tcp")) {
            map.put("cdo.net4j.tcp", CDOResourceFactory.INSTANCE);
        }
        if (!map.containsKey("cdo")) {
            map.put("cdo", CDOResourceFactory.INSTANCE);
        }
    }

    public EdaptCDOViewProvider getEdaptCDOViewProvider() {
        return this.edaptCDOViewProvider;
    }

    private void init() {
        this.releaseMap = new HashMap();
        HashMap<EPackage, String> packageMap = new HashMap<EPackage, String>();
        for (Release release : this.history.getReleases()) {
            if (release.isLastRelease()) continue;
            this.updatePackages(release, packageMap);
            this.registerRelease(release, packageMap);
        }
    }

    private void registerRelease(Release release, Map<EPackage, String> packageMap) {
        for (Map.Entry<EPackage, String> entry : packageMap.entrySet()) {
            String nsURI = entry.getValue();
            java.util.Set<Release> releases = this.releaseMap.get(nsURI);
            if (releases == null) {
                releases = new HashSet<Release>();
                this.releaseMap.put(nsURI, releases);
            }
            releases.add(release);
        }
    }

    private void updatePackages(Release release, Map<EPackage, String> packageMap) {
        TreeIterator i = release.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (element instanceof Set) {
                Set set = (Set)element;
                if (set.getFeature() != EcorePackage.eINSTANCE.getEPackage_NsURI()) continue;
                EPackage ePackage = (EPackage)set.getElement();
                String nsURI = (String)set.getValue();
                packageMap.put(ePackage, nsURI);
                continue;
            }
            if (!(element instanceof Delete)) continue;
            Delete delete = (Delete)element;
            packageMap.remove(delete.getElement());
        }
    }

    public void migrateAndCopy(CDOURIData sourceURIData, CDOURIData targetURIData, IProgressMonitor monitor) throws MigrationException {
        try {
            ResourceSetImpl set = new ResourceSetImpl();
            set.getResource(sourceURIData.toURI(), true);
        }
        catch (Exception exception) {}
        CDOResource rootResource = this.getEdaptCDOViewProvider().getRootResource(sourceURIData.getRepositoryName());
        ArrayList<CDOResource> cdoResCollection = new ArrayList<CDOResource>();
        CDOMigrator.collectResources(cdoResCollection, (CDOResourceNode)rootResource);
        for (CDOResource cdoRes : cdoResCollection) {
            ArrayList<URI> sourceConnectionAwareURIS = new ArrayList<URI>();
            URI sourceURI = CDOMigrator.cdoConnectionAwareURI(cdoRes.getURI(), sourceURIData);
            sourceConnectionAwareURIS.add(sourceURI);
            ArrayList<URI> targetConnectionAwareURIS = new ArrayList<URI>();
            URI targetURI = CDOMigrator.cdoConnectionAwareURI(cdoRes.getURI(), targetURIData);
            targetConnectionAwareURIS.add(targetURI);
            java.util.Set<Release> releases = this.getRelease(cdoRes);
            Release release = HistoryUtils.getMinimumRelease(releases);
            Model model = this.migrate(sourceConnectionAwareURIS, release, null, monitor);
            if (model == null) {
                throw new MigrationException("Model is up-to-date", null);
            }
            try {
                CDOPersistency.saveModel(model, this.extent, targetConnectionAwareURIS);
            }
            catch (IOException e) {
                throw new MigrationException("Model could not be saved", (Throwable)e);
            }
        }
    }

    public void migrateAndCopy(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor, List<URI> list) throws MigrationException {
        Model model = this.migrate(modelURIs, sourceRelease, targetRelease, monitor);
        if (model == null) {
            throw new MigrationException("Model is up-to-date", null);
        }
        try {
            CDOPersistency.saveModel(model, this.extent, list);
        }
        catch (IOException e) {
            throw new MigrationException("Model could not be saved", (Throwable)e);
        }
    }

    public ResourceSet migrateAndLoad(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        Model model = this.migrate(modelURIs, sourceRelease, targetRelease, monitor);
        if (model == null) {
            return null;
        }
        MaterializingBackwardConverter converter = new MaterializingBackwardConverter();
        return converter.convert(model);
    }

    private Release getLatestRelease() {
        EList releases = this.history.getReleases();
        return (Release)releases.get(releases.size() - 2);
    }

    private Model migrate(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        try {
            Model model;
            if (targetRelease == null) {
                targetRelease = this.getLatestRelease();
            }
            if (sourceRelease == targetRelease) {
                return null;
            }
            monitor.beginTask("Migrate: " + modelURIs, this.numberOfSteps(sourceRelease, targetRelease));
            EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"test"));
            CDOMigrationReconstructor migrationReconstructor = new CDOMigrationReconstructor(modelURIs, sourceRelease, targetRelease, monitor, this.classLoader, this.level, this.resourceSetFactory);
            reconstructor.addReconstructor((IReconstructor)migrationReconstructor);
            reconstructor.reconstruct(targetRelease, false);
            this.extent = reconstructor.getExtent();
            Model model2 = model = migrationReconstructor.getModel();
            return model2;
        }
        catch (WrappedMigrationException e) {
            throw e.getCause();
        }
        finally {
            monitor.done();
        }
    }

    private int numberOfSteps(Release sourceRelease, Release targetRelease) {
        int size = 0;
        boolean inRelease = false;
        for (Release release : this.history.getReleases()) {
            if (inRelease) {
                size += release.getChanges().size();
            }
            if (release == sourceRelease) {
                inRelease = true;
            }
            if (release == targetRelease) break;
        }
        return size;
    }

    public java.util.Set<Release> getRelease(URI modelURI) {
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURI);
        return this.releaseMap.containsKey(nsURI) ? this.releaseMap.get(nsURI) : Collections.emptySet();
    }

    public java.util.Set<Release> getRelease(CDOResource resource) {
        CDOPackageRegistry packageRegistry = resource.cdoView().getSession().getPackageRegistry();
        CDOPackageInfo[] cDOPackageInfoArray = packageRegistry.getPackageInfos();
        int n = cDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageInfo info = cDOPackageInfoArray[n2];
            String packageURI = info.getPackageURI();
            if (this.releaseMap.containsKey(packageURI)) {
                return this.releaseMap.get(packageURI);
            }
            ++n2;
        }
        return Collections.emptySet();
    }

    public Release getRelease(int number) {
        if (number < 0 || number >= this.history.getReleases().size()) {
            return null;
        }
        return (Release)this.history.getReleases().get(number);
    }

    public List<Release> getReleases() {
        ArrayList<Release> releases = new ArrayList<Release>();
        releases.addAll((Collection<Release>)this.history.getReleases());
        releases.remove(this.history.getLastRelease());
        return releases;
    }

    public java.util.Set<String> getNsURIs() {
        return this.releaseMap.keySet();
    }

    public Metamodel getMetamodel(Release release) {
        EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"test"));
        reconstructor.reconstruct(release, false);
        URI metamodelURI = URI.createFileURI((String)new File("metamodel.ecore").getAbsolutePath());
        List rootPackages = ResourceUtils.getRootElements((ResourceSet)reconstructor.getResourceSet(), EPackage.class);
        ResourceSet resourceSet = MetamodelUtils.createIndependentMetamodelCopy((Collection)rootPackages, (URI)metamodelURI);
        return CDOPersistency.loadMetamodel((ResourceSet)resourceSet);
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public static void main(String[] args) {
        MigratorCommandLine commandLine = new MigratorCommandLine(args);
        List modelURIs = commandLine.getModelURIs();
        int sourceReleaseNumber = commandLine.getSourceReleaseNumber();
        int targetReleaseNumber = commandLine.getTargetReleaseNumber();
        try {
            for (Class library : commandLine.getLibraries()) {
                OperationRegistry.getInstance().registerLibrary(library);
            }
            for (Class operation : commandLine.getOperations()) {
                OperationRegistry.getInstance().registerOperation(operation);
            }
            CDOMigrator migrator = new CDOMigrator(commandLine.getHistoryURI(), (IClassLoader)new ClassLoaderFacade(Thread.currentThread().getContextClassLoader()));
            migrator.setLevel(commandLine.getLevel());
            java.util.Set<Release> releases = migrator.getRelease((URI)modelURIs.get(0));
            Release sourceRelease = null;
            sourceRelease = sourceReleaseNumber != -1 ? HistoryUtils.getRelease(releases, (int)sourceReleaseNumber) : releases.iterator().next();
            if (commandLine.isBackup()) {
                Metamodel metamodel = migrator.getMetamodel(sourceRelease);
                try {
                    BackupUtils.backup((List)modelURIs, (Metamodel)metamodel);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
            Release targetRelease = migrator.getRelease(targetReleaseNumber);
            migrator.migrateAndCopy(modelURIs, sourceRelease, targetRelease, (IProgressMonitor)new PrintStreamProgressMonitor(System.out), null);
        }
        catch (MigrationException e) {
            System.err.println(e.getMessage());
            System.err.println(e.getCause().getMessage());
        }
    }

    public void setResourceSetFactory(IResourceSetFactory resourceSetFactory) {
        if (resourceSetFactory != null) {
            this.resourceSetFactory = resourceSetFactory;
        }
    }

    public IResourceSetFactory getResourceSetFactory() {
        return this.resourceSetFactory;
    }

    /*
     * Unable to fully structure code
     */
    public void clearCDORepositories(String host, String port, String repo) {
        block5: {
            set = new ResourceSetImpl();
            uri = CDOMigrator.cdoConnectionAwareURI(host, port, repo, "");
            try {
                set.getResource(uri, true);
                break block5;
            }
            catch (Exception v0) {
                rootResource = this.getEdaptCDOViewProvider().getRootResource(repo);
                if (rootResource == null) break block5;
                cdoResCollection = new ArrayList<CDOResource>();
                CDOMigrator.collectResources(cdoResCollection, (CDOResourceNode)rootResource);
                ** for (res : cdoResCollection)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    res.delete(null);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
lbl19:
            // 1 sources

            CDOMigrator.commitTransaction((CDOTransaction)rootResource.cdoView());
        }
    }

    public static void copy(Metamodel metamodel, ResourceSet sourceModels, List<URI> cdoURIs, IResourceSetFactory resourceSetFactory) {
        ResourceSet set = resourceSetFactory.createResourceSet();
        for (Resource resource : sourceModels.getResources()) {
            int index = sourceModels.getResources().indexOf((Object)resource);
            URI cdoResourceURI = cdoURIs.get(index);
            CDOResource cdoLoadResource = CDOMigrator.cdoCreateResource(set, cdoResourceURI, metamodel);
            EObject loadElement = (EObject)resource.getContents().get(0);
            EObject copy = EcoreUtil.copy((EObject)loadElement);
            cdoLoadResource.getContents().add((Object)copy);
            try {
                cdoLoadResource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static CDOResource cdoCreateResource(ResourceSet set, URI cdoResourceURI, Metamodel mmmeta) {
        ResourceUtils.register((List)mmmeta.getEPackages(), (EPackage.Registry)set.getPackageRegistry());
        Resource resource = set.createResource(cdoResourceURI);
        if (resource instanceof CDOResource) {
            return (CDOResource)resource;
        }
        return null;
    }

    public static URI cdoConnectionAwareURI(String host, String port, String repo, String resourceName) {
        CDOURIData cdouriData = new CDOURIData();
        cdouriData.setScheme("cdo.net4j.tcp");
        cdouriData.setAuthority(String.valueOf(host) + ":" + port);
        cdouriData.setRepositoryName(repo);
        cdouriData.setResourcePath((IPath)new Path(resourceName));
        return cdouriData.toURI();
    }

    public static URI cdoConnectionAwareURI(URI canonicalURI, String authority) {
        CDOURIData cdouriData = new CDOURIData(canonicalURI);
        cdouriData.setScheme("cdo.net4j.tcp");
        cdouriData.setAuthority(authority);
        return cdouriData.toURI();
    }

    public static URI cdoConnectionAwareURI(URI canonicalURI, CDOURIData data) {
        String path = CDOURIUtil.extractResourcePath((URI)canonicalURI);
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        CDOURIData cdouriData = new CDOURIData();
        cdouriData.setScheme("cdo.net4j.tcp");
        cdouriData.setAuthority(data.getAuthority());
        cdouriData.setResourcePath((IPath)new Path(path));
        cdouriData.setRepositoryName(data.getRepositoryName());
        cdouriData.setUserName(data.getUserName());
        cdouriData.setPassWord(data.getPassWord());
        return cdouriData.toURI();
    }

    public static void clear(List<URI> cdoSourceURIs, ResourceSetFactoryImpl resourceSetFactoryImpl) {
        ResourceSet set = resourceSetFactoryImpl.createResourceSet();
        for (URI uri : cdoSourceURIs) {
            try {
                Resource resource = set.getResource(uri, true);
                if (!(resource instanceof CDOResource)) continue;
                CDOResource cdoRes = (CDOResource)resource;
                CDOTransaction transaction = (CDOTransaction)cdoRes.cdoView();
                try {
                    cdoRes.delete(null);
                    transaction.commit();
                }
                catch (IOException iOException) {
                }
                catch (ConcurrentAccessException concurrentAccessException) {
                }
                catch (CommitException commitException) {}
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public static URI cdoConnectionAwareURI(URI sourceURI, String host, String port, String repo) {
        try {
            URI.createFileURI((String)sourceURI.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fileName = sourceURI.lastSegment();
        String resourceName = fileName.substring(0, fileName.lastIndexOf("."));
        return CDOMigrator.cdoConnectionAwareURI(host, port, repo, resourceName);
    }

    public static List<URI> collectConnectionAwareURIs(CDOURIData data, List<CDOResource> cdoResCollection, CDOResourceNode node) {
        ArrayList<URI> connectionAwareURIs = new ArrayList<URI>();
        CDOMigrator.collectResources(cdoResCollection, node);
        for (CDOResource res : cdoResCollection) {
            URI connectionAware = CDOMigrator.cdoConnectionAwareURI(res.getURI(), data.getAuthority());
            connectionAwareURIs.add(connectionAware);
        }
        return connectionAwareURIs;
    }

    public static void collectResources(List<CDOResource> cdoResCollection, CDOResourceNode node) {
        CDOResourceLeaf leaf;
        if (node.isRoot()) {
            CDOResource rootResource = (CDOResource)node;
            for (EObject eo : rootResource.getContents()) {
                if (!(eo instanceof CDOResourceNode)) continue;
                CDOMigrator.collectResources(cdoResCollection, (CDOResourceNode)eo);
            }
        } else if (node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)node;
            for (CDOResourceNode childNode : folder.getNodes()) {
                CDOMigrator.collectResources(cdoResCollection, childNode);
            }
        } else if (node instanceof CDOResourceLeaf && (leaf = (CDOResourceLeaf)node) instanceof CDOResource) {
            CDOResource res = (CDOResource)leaf;
            cdoResCollection.add(res);
        }
    }

    public static boolean commitTransaction(CDOTransaction t) {
        boolean commitFailed = false;
        try {
            t.commit();
        }
        catch (ConcurrentAccessException e) {
            e.printStackTrace();
            commitFailed = true;
        }
        catch (CommitException e) {
            e.printStackTrace();
            commitFailed = true;
        }
        return commitFailed;
    }

    public static EPackage loadEPackageFromEcore(URI expectedTargetMetamodelURI) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(rs.getPackageRegistry());
        rs.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        Resource r = rs.getResource(expectedTargetMetamodelURI, true);
        EObject eObject = (EObject)r.getContents().get(0);
        if (eObject instanceof EPackage) {
            EPackage p = (EPackage)eObject;
            rs.getPackageRegistry().put((Object)p.getNsURI(), (Object)p);
            return p;
        }
        return null;
    }

    public static URI cdoCanonicalURI(URI sourceURI, String repo) {
        String fileName = sourceURI.lastSegment();
        String resourceName = fileName.substring(0, fileName.lastIndexOf("."));
        CDOURIData cdouriData = new CDOURIData();
        cdouriData.setScheme("cdo");
        cdouriData.setRepositoryName(repo);
        cdouriData.setResourcePath((IPath)new Path(resourceName));
        return cdouriData.toURI();
    }
}

