/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.execution;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.history.reconstruction.EcoreReconstructorSwitchBase;
import org.eclipse.emf.edapt.history.reconstruction.FinishedException;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.history.reconstruction.ReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.ResolverBase;
import org.eclipse.emf.edapt.internal.migration.Persistency;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.OperationInstanceConverter;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.WrappedMigrationException;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.OperationChange;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationReconstructor
extends ReconstructorBase {
    protected final Release sourceRelease;
    protected final Release targetRelease;
    protected final List<URI> modelURIs;
    protected MetamodelExtent extent;
    protected Repository repository;
    private boolean enabled = false;
    private boolean started = false;
    private Change trigger = null;
    private Mapping mapping;
    private final IProgressMonitor monitor;
    private MigrationReconstructorSwitch migrationSwitch;
    private CustomMigration customMigration;
    private final IClassLoader classLoader;
    private final ValidationLevel level;
    protected IResourceSetFactory resourceSetFactory;

    public MigrationReconstructor(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor, IClassLoader classLoader, ValidationLevel level, IResourceSetFactory resourceSetFactory) {
        this.modelURIs = modelURIs;
        this.sourceRelease = sourceRelease;
        this.targetRelease = targetRelease;
        this.monitor = monitor;
        this.classLoader = classLoader;
        this.level = level;
        this.resourceSetFactory = resourceSetFactory;
    }

    @Override
    public void init(Mapping mapping, MetamodelExtent extent) {
        this.migrationSwitch = new MigrationReconstructorSwitch();
        this.extent = extent;
        this.mapping = mapping;
    }

    @Override
    public void startRelease(Release originalRelease) {
        if (this.isEnabled()) {
            this.monitor.subTask("Release " + originalRelease.getNumber());
        }
    }

    @Override
    public void endRelease(Release originalRelease) {
        if (originalRelease == this.targetRelease) {
            this.disable();
            this.checkConformanceIfMoreThan(ValidationLevel.HISTORY);
            throw new FinishedException();
        }
        if (originalRelease == this.sourceRelease) {
            this.enable();
            this.started = true;
            this.loadRepository();
        } else if (this.isEnabled()) {
            this.checkConformanceIfMoreThan(ValidationLevel.RELEASE);
        }
    }

    protected void checkConformanceIfMoreThan(ValidationLevel level) {
        if (this.level.compareTo(level) >= 0) {
            this.checkConformance();
        }
    }

    private void checkConformance() {
        try {
            this.repository.getModel().checkConformance();
        }
        catch (MigrationException e) {
            this.throwWrappedMigrationException(e);
        }
    }

    protected void loadRepository() {
        Metamodel metamodel = this.loadMetamodel();
        metamodel.refreshCaches();
        try {
            Model model = Persistency.loadModel(this.modelURIs, (Metamodel)metamodel, (IResourceSetFactory)this.resourceSetFactory);
            this.repository = MigrationFactory.eINSTANCE.createRepository();
            this.repository.setMetamodel(metamodel);
            this.repository.setModel(model);
            this.checkConformanceIfMoreThan(ValidationLevel.HISTORY);
        }
        catch (IOException e) {
            this.throwWrappedMigrationException("Model could not be loaded", e);
        }
    }

    protected Metamodel loadMetamodel() {
        URI metamodelURI = URI.createFileURI((String)new File("metamodel.ecore").getAbsolutePath());
        Collection rootPackages = this.extent.getRootPackages();
        ResourceSet resourceSet = MetamodelUtils.createIndependentMetamodelCopy((Collection)rootPackages, (URI)metamodelURI);
        return Persistency.loadMetamodel((ResourceSet)resourceSet);
    }

    @Override
    public void startChange(Change change) {
        if (this.isEnabled()) {
            if (this.isStarted()) {
                this.migrationSwitch.doSwitch(change);
            }
            this.checkPause(change);
        }
    }

    @Override
    public void endChange(Change change) {
        if (this.isEnabled()) {
            this.checkResume(change);
            if (this.isStarted()) {
                if (change instanceof MigrationChange && this.customMigration != null) {
                    try {
                        try {
                            this.customMigration.migrateAfter(this.repository.getModel(), this.repository.getMetamodel());
                            this.monitor.worked(1);
                            this.checkConformanceIfMoreThan(ValidationLevel.CUSTOM_MIGRATION);
                        }
                        catch (MigrationException e) {
                            this.throwWrappedMigrationException(e);
                            this.customMigration = null;
                        }
                    }
                    finally {
                        this.customMigration = null;
                    }
                } else if (change.eContainer() instanceof Release) {
                    this.monitor.worked(1);
                    this.checkConformanceIfMoreThan(ValidationLevel.CHANGE);
                }
            }
        }
    }

    private void checkResume(Change originalChange) {
        if (this.trigger == originalChange) {
            this.started = true;
            this.trigger = null;
        }
    }

    private void checkPause(Change originalChange) {
        if (this.trigger != null) {
            return;
        }
        if (originalChange instanceof OperationChange || originalChange instanceof Delete) {
            this.started = false;
            this.trigger = originalChange;
        }
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void disable() {
        this.enabled = false;
    }

    protected void enable() {
        this.enabled = true;
    }

    protected void throwWrappedMigrationException(String message, Throwable e) {
        MigrationException me = new MigrationException(message, e);
        this.throwWrappedMigrationException(me);
    }

    private void throwWrappedMigrationException(MigrationException me) {
        throw new WrappedMigrationException(me);
    }

    public Model getModel() {
        if (this.repository == null) {
            return null;
        }
        return this.repository.getModel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MigrationReconstructorSwitch
    extends EcoreReconstructorSwitchBase<Object> {
        private final ResolverBase resolver = new ResolverBase(){

            protected EObject doResolve(EObject element) {
                element = MigrationReconstructor.this.mapping.resolveTarget(element);
                element = MigrationReconstructorSwitch.this.find(element);
                return element;
            }
        };

        private MigrationReconstructorSwitch() {
        }

        @Override
        public Object caseSet(Set set) {
            EObject element = set.getElement();
            EStructuralFeature feature = set.getFeature();
            Object value = set.getValue();
            if (feature == EcorePackage.eINSTANCE.getEReference_EOpposite()) {
                MigrationReconstructor.this.repository.getMetamodel().setEOpposite((EReference)this.resolve(element), (EReference)this.resolve((EObject)value));
            } else if (feature instanceof EReference) {
                EObject resolve = this.resolve((EObject)value);
                if (resolve instanceof EClass && "EGenericType".equals(((EClass)resolve).getName())) {
                    System.out.println();
                    this.resolve((EObject)value);
                }
                this.set(this.resolve(element), feature, resolve);
            } else {
                this.set(this.resolve(element), feature, value);
            }
            return set;
        }

        @Override
        public Object caseAdd(Add add) {
            EObject element = add.getElement();
            EStructuralFeature feature = add.getFeature();
            Object value = add.getValue();
            if (feature instanceof EReference) {
                this.add(this.resolve(element), feature, this.resolve((EObject)value));
            } else {
                this.add(this.resolve(element), feature, value);
            }
            return add;
        }

        @Override
        public Object caseRemove(Remove remove) {
            EObject element = remove.getElement();
            EStructuralFeature feature = remove.getFeature();
            Object value = remove.getValue();
            if (feature instanceof EReference) {
                this.remove(this.resolve(element), feature, this.resolve((EObject)value));
            } else {
                this.remove(this.resolve(element), feature, value);
            }
            return remove;
        }

        @Override
        public Object caseCreate(Create create) {
            EObject element = create.getTarget();
            EReference reference = create.getReference();
            this.create(this.resolve(element), reference, create.getElement().eClass());
            return create;
        }

        @Override
        public Object caseDelete(Delete delete) {
            EObject element = delete.getElement();
            this.delete(this.resolve(element));
            return delete;
        }

        @Override
        public Object caseMove(Move move) {
            this.move(this.resolve(move.getElement()), this.resolve(move.getTarget()), move.getReference());
            return move;
        }

        @Override
        public Object caseMigrationChange(MigrationChange change) {
            try {
                String migration = change.getMigration();
                Class c = MigrationReconstructor.this.classLoader.load(migration);
                MigrationReconstructor.this.customMigration = (CustomMigration)c.newInstance();
                MigrationReconstructor.this.customMigration.migrateBefore(MigrationReconstructor.this.repository.getModel(), MigrationReconstructor.this.repository.getMetamodel());
            }
            catch (ClassNotFoundException e) {
                MigrationReconstructor.this.throwWrappedMigrationException("Custom migration could not be loaded", e);
            }
            catch (InstantiationException e) {
                MigrationReconstructor.this.throwWrappedMigrationException("Custom migration could not be instantiated", e);
            }
            catch (IllegalAccessException e) {
                MigrationReconstructor.this.throwWrappedMigrationException("Custom migration could not be accessed", e);
            }
            catch (MigrationException e) {
                MigrationReconstructor.this.throwWrappedMigrationException(e);
            }
            return change;
        }

        @Override
        public Object caseOperationChange(OperationChange change) {
            OperationInstance operationInstance = (OperationInstance)this.resolver.copyResolve(change.getOperation(), true);
            OperationImplementation operation = OperationInstanceConverter.convert(operationInstance, MigrationReconstructor.this.repository.getMetamodel());
            if (operation == null) {
                MigrationReconstructor.this.throwWrappedMigrationException("Operation could not be found: " + operationInstance.getName(), null);
            } else {
                try {
                    operation.checkAndExecute(MigrationReconstructor.this.repository.getMetamodel(), MigrationReconstructor.this.repository.getModel());
                }
                catch (MigrationException e) {
                    MigrationReconstructor.this.throwWrappedMigrationException(e);
                }
            }
            return change;
        }

        private EObject resolve(EObject element) {
            return this.resolver.resolve(element);
        }

        private EObject find(EObject sourceElement) {
            if (sourceElement == EcorePackage.eINSTANCE) {
                return sourceElement;
            }
            EObject sourceParent = sourceElement.eContainer();
            if (sourceParent == null) {
                EPackage sourcePackage = (EPackage)sourceElement;
                for (EPackage targetPackage : MigrationReconstructor.this.repository.getMetamodel().getEPackages()) {
                    if (!targetPackage.getNsURI().equals(sourcePackage.getNsURI())) continue;
                    return targetPackage;
                }
                return sourcePackage;
            }
            EObject targetParent = this.find(sourceParent);
            if (targetParent == sourceParent) {
                return sourceElement;
            }
            EReference reference = sourceElement.eContainmentFeature();
            if (reference.isMany()) {
                List targetChildren = (List)targetParent.eGet((EStructuralFeature)reference);
                List sourceChildren = (List)sourceParent.eGet((EStructuralFeature)reference);
                int index = sourceChildren.indexOf(sourceElement);
                EObject targetElement = (EObject)targetChildren.get(index);
                return targetElement;
            }
            EObject targetElement = (EObject)targetParent.eGet((EStructuralFeature)reference);
            return targetElement;
        }
    }
}

