/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.editor.InitializeChildCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateChildAction;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CreateNewChildDialog
extends Dialog {
    private final String title;
    private final ISelectionProvider selectionProvider;
    private final EObject parent;

    public CreateNewChildDialog(Shell parentShell, String title, EObject parent, ISelectionProvider selectionProvider) {
        super(parentShell);
        this.title = title;
        this.parent = parent;
        this.selectionProvider = selectionProvider;
    }

    protected final ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(32);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parentComposite) {
        ChildrenDescriptorCollector childrenDescriptorCollector = new ChildrenDescriptorCollector();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.parent);
        final CreateNewChildDialog currentDialog = this;
        final List<Action> actions = this.getNewChildActions(childrenDescriptorCollector.getDescriptors(this.parent), editingDomain, this.parent);
        TableViewer list = new TableViewer(parentComposite);
        list.getControl().setLayoutData((Object)new GridData(1808));
        list.setContentProvider((IContentProvider)new ArrayContentProvider());
        list.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Action action = (Action)element;
                StringBuilder builder = new StringBuilder(action.getText());
                if (action.getAccelerator() > 0) {
                    builder.append(" [");
                    builder.append(Character.toUpperCase((char)action.getAccelerator()));
                    builder.append("]");
                }
                return builder.toString();
            }

            public Image getImage(Object element) {
                return ((Action)element).getImageDescriptor().createImage();
            }
        });
        list.setInput((Object)actions.toArray());
        list.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Action action = (Action)((StructuredSelection)event.getSelection()).getFirstElement();
                action.run();
                currentDialog.close();
            }
        });
        list.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                for (Action a : actions) {
                    if (a.getAccelerator() != e.keyCode) continue;
                    a.run();
                    currentDialog.close();
                    break;
                }
            }
        });
        return parentComposite;
    }

    protected List<Action> getNewChildActions(Collection<?> descriptors, EditingDomain domain, EObject eObject) {
        ArrayList<Action> result = new ArrayList<Action>();
        for (Object descriptor : descriptors) {
            CommandParameter cp = (CommandParameter)descriptor;
            if (!CommandParameter.class.isInstance(descriptor) || cp.getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            result.add((Action)new CreateChildAction(eObject, domain, this.getSelectionProvider(), cp, (CreateElementCallback)new InitializeChildCallback()));
        }
        return result;
    }
}

