/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.parts;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.commands.UpdateLinkedEReferenceDeferredCommand;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceEditPart;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;

public class EReferenceUtils {
    public static void trackReferences(EReferenceEditPart referenceEditPart) {
        EReferenceEditPart slavePart;
        EReferenceEditPart masterPart;
        EObject eReference = referenceEditPart.resolveSemanticElement();
        if (!(eReference instanceof EReference)) {
            return;
        }
        EditPart targetPart = referenceEditPart.getTarget();
        if (!(targetPart instanceof IGraphicalEditPart)) {
            return;
        }
        EReferenceEditPart oppositeEditPart = null;
        for (Object part : ((IGraphicalEditPart)targetPart).getSourceConnections()) {
            if (!(part instanceof EReferenceEditPart) || ((EReferenceEditPart)((Object)part)).resolveSemanticElement() != ((EReference)eReference).getEOpposite()) continue;
            oppositeEditPart = (EReferenceEditPart)((Object)part);
            break;
        }
        if (oppositeEditPart == null) {
            return;
        }
        if (oppositeEditPart.getSelected() != 0) {
            referenceEditPart.getPrimaryShape().setHideLine(true);
            oppositeEditPart.getPrimaryShape().setHideLine(false);
            masterPart = oppositeEditPart;
            slavePart = referenceEditPart;
        } else {
            oppositeEditPart.getPrimaryShape().setHideLine(true);
            referenceEditPart.getPrimaryShape().setHideLine(false);
            masterPart = referenceEditPart;
            slavePart = oppositeEditPart;
        }
        TransactionalEditingDomain editingDomain = masterPart.getEditingDomain();
        ICommandProxy cmd = new ICommandProxy((ICommand)new UpdateLinkedEReferenceDeferredCommand(editingDomain, masterPart, slavePart));
        EReferenceUtils.executeCommand((Command)cmd, (IGraphicalEditPart)masterPart);
    }

    public static void executeCommand(final Command cmd, IGraphicalEditPart part) {
        Map<String, Boolean> options = null;
        boolean isActivating = true;
        EditPartViewer viewer = part.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)part, (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(part.getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError(Messages.EReferenceUtils_CanNotExecute, e);
        }
    }
}

