/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceUtils;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EReferenceItemSemanticEditPolicy;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;

public class EReferenceEditPart
extends ConnectionNodeEditPart {
    private boolean selectable = true;
    public static final int VISUAL_ID = 3002;

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getNotifier() instanceof EReference) {
            switch (notification.getFeatureID(EReference.class)) {
                case 18: {
                    this.refreshSourceDecoration();
                    break;
                }
                case 21: {
                    this.refreshLinkedReference();
                    this.trackLinkedReference();
                }
            }
        }
        if (NotationPackage.Literals.ROUTING_STYLE__ROUTING.equals(notification.getFeature()) || notification.getNotifier() instanceof RelativeBendpoints || notification.getNotifier() instanceof Anchor) {
            this.trackLinkedReference();
        }
        super.handleNotificationEvent(notification);
    }

    protected void trackLinkedReference() {
        EObject semanticElement = this.resolveSemanticElement();
        if (!(semanticElement instanceof EReference)) {
            return;
        }
        if (((EReference)semanticElement).getEOpposite() != null) {
            EReferenceUtils.trackReferences(this);
        }
    }

    protected void refreshLinkedReference() {
        EObject semanticElement = this.resolveSemanticElement();
        if (!(semanticElement instanceof EReference)) {
            return;
        }
        if (((EReference)semanticElement).getEOpposite() != null) {
            this.getPrimaryShape().displayTargetDecoration(false);
        } else {
            this.getPrimaryShape().setHideLine(false);
            this.getPrimaryShape().displayTargetDecoration(true);
        }
    }

    public EReferenceEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EReferenceItemSemanticEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected Connection createConnectionFigure() {
        return new SolidLineWDstArrow();
    }

    public SolidLineWDstArrow getPrimaryShape() {
        return (SolidLineWDstArrow)this.getFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshSourceDecoration();
        this.refreshLinkedReference();
    }

    protected void refreshSourceDecoration() {
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof EReference) {
            ((SolidLineWDstArrow)this.getFigure()).displaySourceDecoration(((EReference)semanticElement).isContainment());
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public class SolidLineWDstArrow
    extends PolylineConnectionEx {
        private boolean hideLine;

        public boolean isHideLine() {
            return this.hideLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHideLine(boolean hideLine) {
            this.hideLine = hideLine;
            EReferenceEditPart eReferenceEditPart = EReferenceEditPart.this;
            synchronized (eReferenceEditPart) {
                if (hideLine) {
                    EReferenceEditPart.this.getViewer().deselect((EditPart)EReferenceEditPart.this);
                    EReferenceEditPart.this.setSelected(0);
                    EReferenceEditPart.this.setSelectable(false);
                } else {
                    EReferenceEditPart.this.setSelectable(true);
                }
            }
        }

        public SolidLineWDstArrow() {
            this.setTargetDecoration(this.createTargetDecoration());
        }

        public void displayTargetDecoration(boolean display) {
            if (display) {
                this.setTargetDecoration(this.createTargetDecoration());
            } else if (this.getTargetDecoration() != null) {
                this.setTargetDecoration(null);
            }
        }

        public void displaySourceDecoration(boolean display) {
            if (display) {
                this.setSourceDecoration(this.createSourceDecoration());
            } else if (this.getSourceDecoration() != null) {
                this.setSourceDecoration(null);
            }
        }

        private RotatableDecoration createTargetDecoration() {
            PolylineDecoration df = new PolylineDecoration();
            PointList pl = new PointList();
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-1), EReferenceEditPart.this.getMapMode().DPtoLP(1));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(0), EReferenceEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-1), EReferenceEditPart.this.getMapMode().DPtoLP(-1));
            df.setTemplate(pl);
            df.setScale((double)EReferenceEditPart.this.getMapMode().DPtoLP(7), (double)EReferenceEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        private RotatableDecoration createSourceDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            PointList pl = new PointList();
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-1), EReferenceEditPart.this.getMapMode().DPtoLP(1));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(0), EReferenceEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-1), EReferenceEditPart.this.getMapMode().DPtoLP(-1));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-2), EReferenceEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(EReferenceEditPart.this.getMapMode().DPtoLP(-1), EReferenceEditPart.this.getMapMode().DPtoLP(1));
            df.setTemplate(pl);
            df.setScale((double)EReferenceEditPart.this.getMapMode().DPtoLP(7), (double)EReferenceEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        public void paintFigure(Graphics graphics) {
            if (this.hideLine) {
                return;
            }
            super.paintFigure(graphics);
        }
    }
}

