/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.PluginTransfer;

public class OutlineDragAdapter
extends DragSourceAdapter {
    private ISelectionProvider selectionProvider;

    public OutlineDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public Transfer[] getSupportedDragTransfers() {
        LinkedHashSet<Object> supportedTypes = new LinkedHashSet<Object>();
        supportedTypes.add(PluginTransfer.getInstance());
        supportedTypes.add(LocalSelectionTransfer.getTransfer());
        Transfer[] transfers = supportedTypes.toArray(new Transfer[supportedTypes.size()]);
        return transfers;
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = selection;
        } else if (!PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            event.doit = false;
        }
    }

    public void dragStart(DragSourceEvent event) {
        try {
            IStructuredSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                event.doit = true;
            } else {
                event.doit = false;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected IStructuredSelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        ArrayList<Object> transferData = new ArrayList<Object>();
        for (Object sel : selection) {
            if (!(sel instanceof IWrapperItemProvider) && !(sel instanceof FeatureMap.Entry) && !(sel instanceof EObject) || sel instanceof View) continue;
            transferData.add(AdapterFactoryEditingDomain.unwrap(sel));
        }
        return new StructuredSelection(transferData);
    }
}

