/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.figures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ToolbarLayoutExt
extends ToolbarLayout {
    private boolean expandLastItemMajorAxis = false;

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(this.getChildPreferredSize(child, wHint, hHint));
            minSizes[i] = this.transposer.t(this.getChildMinimumSize(child, wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.spacing) - (totalMinHeight += (numChildren - 1) * this.spacing);
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        int heightNotUsed = 0;
        if (amntShrinkHeight < 0) {
            heightNotUsed = -amntShrinkHeight;
            amntShrinkHeight = 0;
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int width = Math.min(prefWidth, this.transposer.t((Dimension)child.getMaximumSize()).width);
            if (this.matchWidth) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.minorAlignment) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            if (this.isExpandLastItemMajorAxis() && i2 == numChildren - 1) {
                newBounds.height += heightNotUsed;
            }
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }

    public boolean isExpandLastItemMajorAxis() {
        return this.expandLastItemMajorAxis;
    }

    public void setExpandLastItemMajorAxis(boolean expandLastItemMajorAxis) {
        this.expandLastItemMajorAxis = expandLastItemMajorAxis;
    }
}

