/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.MultiDiagramLinkStyle;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class RemoveDiagramCommand
extends AbstractTransactionalCommand {
    private MultiDiagramLinkStyle diagramFacet;

    public RemoveDiagramCommand(MultiDiagramLinkStyle linkStyle) {
        super(TransactionUtil.getEditingDomain((EObject)linkStyle), Messages.RemoveDiagramCommand_RemoveDiagram, null);
        this.diagramFacet = linkStyle;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            EList diagramLinks = this.diagramFacet.getDiagramLinks();
            for (Diagram diagram : diagramLinks) {
                if (diagram == null) continue;
                URI uri = diagram.eResource().getURI();
                uri = uri.appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
                URIEditorInput editorInput = new URIEditorInput(uri);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = page.findEditor((IEditorInput)editorInput);
                if (editor != null) {
                    page.closeEditor(editor, true);
                }
                assert (this.diagramFacet.eResource() != null);
                this.diagramFacet.eResource().getContents().remove((Object)diagram);
            }
            diagramLinks.clear();
            return CommandResult.newOKCommandResult();
        }
        catch (Exception ex) {
            throw new ExecutionException(Messages.RemoveDiagramCommand_CanNotRemove, (Throwable)ex);
        }
    }
}

