/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.commands.ArrangeRelatedNodesCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedMissingNodesCommand;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreRelatedLinksAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "restoreRelatedLinksAction";

    public RestoreRelatedLinksAction() {
        this.setId(ID);
        this.setText(Messages.RestoreRelatedLinksAction_RestoreRelatedElements);
        this.setToolTipText(Messages.RestoreRelatedLinksAction_RestoreRelatedElements_tooltip);
        this.setImageDescriptor(EcoreDiagramEditorPlugin.getBundledImageDescriptor("icons/etool16/restorerelatedlinks_exec.gif"));
    }

    private Diagram getCurrentDiagram() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof DiagramEditor) {
            this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
            return ((View)this.host.getModel()).getDiagram();
        }
        return null;
    }

    private List<View> getSelection() {
        ArrayList<View> viewSelected = new ArrayList<View>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        for (Object object : ((IStructuredSelection)selection).toList()) {
            if (!(object instanceof IGraphicalEditPart) || object instanceof DiagramEditPart) continue;
            viewSelected.add(((IGraphicalEditPart)object).getNotationView());
        }
        return viewSelected;
    }

    public void run() {
        List<View> selection = this.getSelection();
        if (!selection.isEmpty() && this.host instanceof DiagramEditPart) {
            DiagramCommandStack commandStack = this.host.getDiagramEditDomain().getDiagramCommandStack();
            CompoundCommand cmd = new CompoundCommand(Messages.RestoreRelatedLinksAction_RestoreRelatedLinks);
            cmd.add((Command)new ICommandProxy((ICommand)new RestoreRelatedMissingNodesCommand((DiagramEditPart)this.host, selection)));
            cmd.add((Command)new ICommandProxy((ICommand)new RestoreRelatedLinksCommand((DiagramEditPart)this.host, selection)));
            cmd.add((Command)new ICommandProxy((ICommand)new ArrangeRelatedNodesCommand((DiagramEditPart)this.host, selection)));
            commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public boolean isEnabled() {
        if (!this.getSelection().isEmpty()) {
            Diagram diagram = this.getCurrentDiagram();
            return diagram != null && "EcoreTools".equals(this.getCurrentDiagram().getType());
        }
        return false;
    }
}

