/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WhitespaceSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private CCombo whitespaceCb;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.whitespaceCb = this.getWidgetFactory().createCCombo(composite, 0x800808);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.whitespaceCb, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.whitespaceCb.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.whitespaceCb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WhitespaceSection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing) {
            final int newWhitespace = this.whitespaceCb.getSelectionIndex();
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                int oldWhitespace = ExtendedMetaData.INSTANCE.getWhiteSpaceFacet((EDataType)this.getEObject());
                if (oldWhitespace != newWhitespace) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setWhiteSpaceFacet((EDataType)WhitespaceSection.this.getEObject(), newWhitespace);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    int oldWhitespace = ExtendedMetaData.INSTANCE.getWhiteSpaceFacet((EDataType)nextObject);
                    if (oldWhitespace == newWhitespace) continue;
                    compoundCommand.append((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setWhiteSpaceFacet((EDataType)nextObject, newWhitespace);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.whitespaceCb.setItems(ExtendedMetaData.WHITE_SPACE_KINDS);
        int whitespace = ExtendedMetaData.INSTANCE.getWhiteSpaceFacet((EDataType)this.getEObject());
        this.whitespaceCb.setText(ExtendedMetaData.WHITE_SPACE_KINDS[whitespace]);
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.WhitespaceSection_Whitespace;
    }
}

