/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;

public abstract class EMFRecordingChangeCommand
extends AbstractCommand {
    private Set<Resource> notifiers;
    private ChangeRecorder recorder = new ChangeRecorder();
    private ChangeDescription change;

    public EMFRecordingChangeCommand(Resource resource) {
        super(Messages.EMFRecordingChangeCommand_RecordingChangeCommand);
        this.notifiers = Collections.singleton(resource);
    }

    public void execute() {
        try {
            this.recorder.beginRecording(this.notifiers);
            this.doExecute();
        }
        finally {
            this.change = this.recorder.endRecording();
        }
    }

    protected boolean prepare() {
        return this.change == null;
    }

    protected abstract void doExecute();

    private void applyChanges() {
        try {
            this.recorder.beginRecording(this.notifiers);
            this.change.apply();
        }
        finally {
            this.change = this.recorder.endRecording();
        }
    }

    public boolean canUndo() {
        return this.change != null;
    }

    public void undo() {
        this.applyChanges();
    }

    public void redo() {
        this.applyChanges();
    }

    public void dispose() {
        this.change = null;
        this.recorder = null;
        this.notifiers = null;
    }
}

