/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.commands.FilterSelectionCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HideSelectionAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "hideSelectionAction";

    public HideSelectionAction() {
        this.setId(ID);
        this.setText(Messages.HideSelectionAction_HideSelection);
        this.setToolTipText(Messages.HideSelectionAction_HideSelection_tooltip);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/hideselection_exec.gif"));
    }

    private List<IGraphicalEditPart> getSelection() {
        ArrayList<IGraphicalEditPart> partSelected = new ArrayList<IGraphicalEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        for (Object object : ((IStructuredSelection)selection).toList()) {
            boolean cfr_ignored_0 = object instanceof IGraphicalEditPart;
            if (object instanceof DiagramEditPart) continue;
            partSelected.add((IGraphicalEditPart)object);
        }
        return partSelected;
    }

    public void run() {
        List<IGraphicalEditPart> selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        TransactionalEditingDomain editingDomain = selection.get(0).getEditingDomain();
        IDiagramEditDomain editDomain = selection.get(0).getDiagramEditDomain();
        ICommandProxy cmd = new ICommandProxy((ICommand)new FilterSelectionCommand(editingDomain, selection, false));
        DiagramCommandStack commandStack = editDomain.getDiagramCommandStack();
        commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isEnabled() {
        return !this.getSelection().isEmpty();
    }
}

