/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.provider.DefinitionItemProviderAdapterFactory;
import org.eclipse.ease.lang.unittest.ui.editor.CustomCodePage;
import org.eclipse.ease.lang.unittest.ui.editor.FileSelectionPage;
import org.eclipse.ease.lang.unittest.ui.editor.OverviewPage;
import org.eclipse.ease.lang.unittest.ui.editor.VariablesPage;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class TestSuiteEditor
extends FormEditor
implements IEditingDomainProvider,
IResourceChangeListener {
    public static final String EDITOR_ID = "org.eclipse.ease.editor.suiteEditor";
    public static final String OVERVIEW_PAGE = "Overview";
    public static final String TEST_SELECTION_PAGE = "Test Selection";
    public static final String VARIABLES_PAGE = "Variables";
    public static final String CUSTOM_CODE_PAGE = "Custom Code";
    private boolean fDirty = false;
    private AdapterFactoryEditingDomain fEditingDomain;
    private ITestSuiteDefinition fTestSuite = null;
    private LocalResourceManager fResourceManager;
    private ComposedAdapterFactory fAdapterFactory;

    public TestSuiteEditor() {
        this.initializeEditingDomain();
        this.addChangeListener();
    }

    private void initializeEditingDomain() {
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new DefinitionItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.fEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.fAdapterFactory, (CommandStack)commandStack, new HashMap());
    }

    private void addChangeListener() {
        this.fEditingDomain.getCommandStack().addCommandStackListener(event -> {
            this.fDirty = true;
            this.firePropertyChange(257);
        });
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        try {
            InputStream content = this.getInputContent();
            this.fTestSuite = UnitTestHelper.loadTestSuite((InputStream)content);
            content.close();
            this.fTestSuite.setResource((Object)this.getFile());
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.ease.lang.unittest.ui", e.getLocalizedMessage(), (Throwable)e);
            throw new PartInitException((IStatus)status);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.ease.lang.unittest.ui", e.getLocalizedMessage(), (Throwable)e);
            throw new PartInitException((IStatus)status);
        }
        this.setPartName(this.getEditorInput().getName());
        this.firePropertyChange(1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this, OVERVIEW_PAGE, OVERVIEW_PAGE));
            this.addPage((IFormPage)new FileSelectionPage(this, TEST_SELECTION_PAGE, TEST_SELECTION_PAGE));
            this.addPage((IFormPage)new VariablesPage(this, VARIABLES_PAGE, VARIABLES_PAGE));
            this.addPage((IFormPage)new CustomCodePage(this, CUSTOM_CODE_PAGE, CUSTOM_CODE_PAGE));
        }
        catch (PartInitException e) {
            Logger.error((String)"org.eclipse.ease.lang.unittest.ui", (String)"Could not create all pages for TestSuiteEditor", (Throwable)e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            byte[] xmlContent = UnitTestHelper.serializeTestSuite((ITestSuiteDefinition)this.getTestSuite());
            this.getFile().setContents((InputStream)new ByteArrayInputStream(xmlContent), true, true, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.fDirty = false;
        this.editorDirtyStateChanged();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }

    public ITestSuiteDefinition getTestSuite() {
        return this.fTestSuite;
    }

    public boolean isDirty() {
        return super.isDirty() | this.fDirty && this.getFile() != null;
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    private InputStream getInputContent() throws CoreException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile().getContents();
        }
        if (editorInput instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)editorInput).getStorage().getContents();
        }
        return null;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.fEditingDomain;
    }

    public void dispose() {
        this.fResourceManager.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public LocalResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public void executeCommand(Command command) {
        this.getEditingDomain().getCommandStack().execute(command);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if ((delta = delta.findMember(this.getFile().getFullPath())) == null) {
            return;
        }
        if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) != 0) {
            IPath newPath = delta.getMovedToPath();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
            if (file != null) {
                System.out.println("Setting input to: " + file);
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.setPartName(this.getEditorInput().getName());
                this.firePropertyChange(1);
                Display.getDefault().asyncExec(() -> {
                    IFormPage activePage = this.getActivePageInstance();
                    if (activePage instanceof FileSelectionPage) {
                        ((FileSelectionPage)activePage).updateTestFiles();
                    }
                });
            }
        }
    }
}

