/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.util.Random;
import java.util.regex.Pattern;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;

public final class PythonHelper {
    public static final String SCRIPT_TYPE_PYTHON = "Python";

    @Deprecated
    private PythonHelper() {
        throw new UnsupportedOperationException("Utility class shall not be instantiated");
    }

    public static String getSaveName(String identifier) {
        if (PythonHelper.isSaveName(identifier)) {
            return identifier;
        }
        StringBuilder buffer = new StringBuilder(identifier.replaceAll("[^a-zA-Z0-9]", "_"));
        if (buffer.length() > 0) {
            char start = buffer.charAt(0);
            if ((start < 'A' || start > 'Z' && start < 'a' || start > 'z') && start != '_') {
                buffer.insert(0, '_');
            }
        } else {
            Random random = new Random();
            buffer.append('_');
            int index = 0;
            while (index < random.nextInt(20)) {
                buffer.append(97 + random.nextInt(26));
                ++index;
            }
        }
        return buffer.toString();
    }

    public static boolean isSaveName(String identifier) {
        return Pattern.matches("[a-zA-Z_$][a-zA-Z0-9_$]*", identifier);
    }

    public static ScriptType getScriptType() {
        ScriptService scriptService = ScriptService.getInstance();
        return (ScriptType)scriptService.getAvailableScriptTypes().get(SCRIPT_TYPE_PYTHON);
    }
}

