/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;

public class RCPWorkspaceMapper {
    private static final String DB_DIRIGIBLE_USERS_LOCAL_WORKSPACE = "/db/dirigible/users/local/workspace/";
    private static Map<String, String> prefixMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> prefixMapEquals = Collections.synchronizedMap(new HashMap());
    private static String workspaceRoot = "/";

    public static String getMappedName(String repositoryName) throws IOException {
        String workspaceName = null;
        if (repositoryName != null && !"".equals(repositoryName)) {
            if (FileSystemUtils.exists((String)repositoryName) && !"/".equals(repositoryName)) {
                return repositoryName;
            }
            String repositoryPathEffect = repositoryName.substring(1);
            if (FileSystemUtils.exists((String)(repositoryPathEffect = repositoryPathEffect.replace(File.separator, "/")))) {
                return repositoryPathEffect;
            }
            RCPWorkspaceMapper.check();
            if (repositoryName.startsWith(workspaceRoot) && repositoryName.length() > workspaceRoot.length()) {
                repositoryName = "/" + repositoryName.substring(workspaceRoot.length() + 1);
            }
            repositoryName = repositoryName.replace(File.separator, "/");
            for (Map.Entry<String, String> prefix : prefixMapEquals.entrySet()) {
                if (!repositoryName.equals(prefix.getKey())) continue;
                workspaceName = prefix.getValue();
                break;
            }
            if (workspaceName == null) {
                for (Map.Entry<String, String> prefix : prefixMap.entrySet()) {
                    if (!repositoryName.startsWith(prefix.getKey()) || prefix.getKey().equals("/")) continue;
                    workspaceName = repositoryName.replace(prefix.getKey(), prefix.getValue());
                    break;
                }
            }
        }
        workspaceName = workspaceName == null ? repositoryName : workspaceName.replace("/", File.separator);
        return workspaceName;
    }

    public static String getReverseMappedName(String workspaceName) {
        if (workspaceName == null || "".endsWith(workspaceName)) {
            return workspaceName;
        }
        if (workspaceName.startsWith(DB_DIRIGIBLE_USERS_LOCAL_WORKSPACE)) {
            return workspaceName;
        }
        workspaceName = workspaceName.substring(workspaceRoot.length());
        workspaceName = workspaceName.replace(File.separator, "/");
        return workspaceName;
    }

    private static void check() throws IOException {
        if (prefixMap.isEmpty()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            File workspaceDirectory = workspace.getRoot().getLocation().toFile();
            workspaceRoot = workspaceDirectory.getCanonicalPath();
            prefixMap.put("/db/dirigible/users/local/workspace", workspaceRoot);
            prefixMap.put(String.valueOf(workspaceRoot) + "/db/dirigible/users/local/workspace", workspaceRoot);
            String db_dirigible_root = String.valueOf(workspaceRoot) + File.separator + "db" + File.separator + "dirigible" + File.separator;
            prefixMap.put("/db/dirigible/registry", String.valueOf(db_dirigible_root) + "registry");
            prefixMap.put("/db/dirigible/sandbox", String.valueOf(db_dirigible_root) + "sandbox");
            prefixMap.put("/db/dirigible/templates", String.valueOf(db_dirigible_root) + "templates");
            prefixMapEquals.put("/", workspaceRoot);
            prefixMapEquals.put("/db", String.valueOf(workspaceRoot) + File.separator + "db");
            prefixMapEquals.put("/db/dirigible", String.valueOf(workspaceRoot) + File.separator + "db" + File.separator + "dirigible");
            prefixMapEquals.put("/db/dirigible/users", String.valueOf(db_dirigible_root) + "users");
            prefixMapEquals.put("/db/dirigible/users/local", String.valueOf(db_dirigible_root) + "users" + File.separator + "local");
            prefixMapEquals.put("/db/dirigible/registry", String.valueOf(db_dirigible_root) + "registry");
            prefixMapEquals.put("/db/dirigible/sandbox", String.valueOf(db_dirigible_root) + "sandbox");
            prefixMapEquals.put("/db/dirigible/templates", String.valueOf(db_dirigible_root) + "templates");
            prefixMapEquals.put("/db/dirigible/default.content", String.valueOf(db_dirigible_root) + "default.content");
        }
    }
}

