/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateTypePage;
import org.eclipse.dirigible.ide.template.ui.js.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TablesTemplateTablePage;
import org.eclipse.jface.wizard.IWizardPage;

public class JavascriptServiceTemplateWizard
extends TemplateWizard {
    private static final String CREATE_SCRIPTING_SERVICE = Messages.JavascriptServiceTemplateWizard_CREATE_SCRIPTING_SERVICE;
    private final JavascriptServiceTemplateModel model;
    private final JavascriptServiceTemplateTypePage typesPage;
    private final TablesTemplateTablePage tablesTemplateTablePage;
    private final JavascriptServiceTemplateTargetLocationPage targetLocationPage;

    public JavascriptServiceTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_SCRIPTING_SERVICE);
        this.model = new JavascriptServiceTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new JavascriptServiceTemplateTypePage(this.model);
        this.tablesTemplateTablePage = new TablesTemplateTablePage(this.model);
        this.targetLocationPage = new JavascriptServiceTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.tablesTemplateTablePage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        JavascriptServiceTemplateGenerator generator = new JavascriptServiceTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof JavascriptServiceTemplateTypePage) {
            String location = this.model.getTemplate().getLocation();
            if (location.indexOf("database") > -1) {
                return this.tablesTemplateTablePage;
            }
            return this.targetLocationPage;
        }
        if (page instanceof TablesTemplateTablePage) {
            return this.targetLocationPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        String location;
        if (page instanceof TablesTemplateTablePage) {
            return this.typesPage;
        }
        if (page instanceof JavascriptServiceTemplateTargetLocationPage && (location = this.model.getTemplate().getLocation()).indexOf("database") > -1) {
            return this.tablesTemplateTablePage;
        }
        return super.getPreviousPage(page);
    }

    protected String openEditorForFileWithExtension() {
        return "js";
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

