/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload;

import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadListener;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.Messages;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadListenerList;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadServiceHandler;

public final class FileUploadHandler {
    private static final String RECEIVER_IS_NULL = Messages.FileUploadHandler_RECEIVER_IS_NULL;
    private static final String LISTENER_IS_NULL = Messages.FileUploadHandler_LISTENER_IS_NULL;
    private final String token;
    private final FileUploadReceiver receiver;
    private final FileUploadListenerList listeners;
    private long maxFileSize = -1L;

    public FileUploadHandler(FileUploadReceiver receiver) {
        if (receiver == null) {
            throw new NullPointerException(RECEIVER_IS_NULL);
        }
        this.token = FileUploadHandlerStore.createToken();
        this.listeners = new FileUploadListenerList();
        this.receiver = receiver;
        FileUploadHandlerStore.getInstance().registerHandler(this.token, this);
    }

    public String getUploadUrl() {
        return FileUploadServiceHandler.getUrl(this.token);
    }

    public FileUploadReceiver getReceiver() {
        return this.receiver;
    }

    public void addUploadListener(FileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException(LISTENER_IS_NULL);
        }
        this.listeners.addUploadListener(listener);
    }

    public void removeUploadListener(FileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException(LISTENER_IS_NULL);
        }
        this.listeners.removeUploadListener(listener);
    }

    public void dispose() {
        FileUploadHandlerStore.getInstance().deregisterHandler(this.token);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    FileUploadListenerList getListeners() {
        return this.listeners;
    }

    String getToken() {
        return this.token;
    }
}

