/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.is.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;

public class IntegrationServiceTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final long serialVersionUID = 7563766695471457264L;
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.IntegrationServiceTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String TARGET_LOCATION = Messages.IntegrationServiceTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateTargetLocationPage";
    private IntegrationServiceTemplateModel model;

    protected IntegrationServiceTemplateTargetLocationPage(IntegrationServiceTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || "".equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.model.validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getDefaultFileName(String preset) {
        String defaultName = "flow_name.flow";
        if (this.model.getTemplate().getLocation().endsWith(".flow")) {
            defaultName = preset == null ? "flow_name.flow" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + ".flow";
        } else if (this.model.getTemplate().getLocation().endsWith(".job")) {
            defaultName = preset == null ? "job_name.job" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + ".job";
        }
        return defaultName;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getArtifactContainerName() {
        return "IntegrationServices";
    }
}

