/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.js;

import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.debug.model.DebugModelFacade;
import org.eclipse.dirigible.ide.editor.js.EditorWidget;
import org.eclipse.dirigible.ide.editor.js.Messages;
import org.eclipse.dirigible.ide.editor.text.editor.ContentProviderException;
import org.eclipse.dirigible.ide.editor.text.editor.EditorMode;
import org.eclipse.dirigible.ide.editor.text.editor.IEditorWidgetListener;
import org.eclipse.dirigible.ide.editor.text.editor.TextEditor;
import org.eclipse.dirigible.ide.shared.editor.SourceFileEditorInput;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class JavaScriptEditor
extends TextEditor {
    private static final String ERROR = Messages.JavaScriptEditor_ERROR;
    private static final String CANNOT_LOAD_DOCUMENT = Messages.JavaScriptEditor_CANNOT_LOAD_DOCUMENT;
    private static final Logger logger = Logger.getLogger(JavaScriptEditor.class);
    private EditorWidget text = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        final JavaScriptEditor textEditor = this;
        IEditorInput input = this.getEditorInput();
        this.text = new EditorWidget(parent, true);
        this.text.setLayoutData(new GridData(4, 4, true, true));
        String fileName = null;
        try {
            if (input instanceof SourceFileEditorInput) {
                SourceFileEditorInput sfei = (SourceFileEditorInput)input;
                fileName = sfei.getName();
            }
            String content = this.getContentProvider(input).getContent(input);
            if (input instanceof SourceFileEditorInput) {
                SourceFileEditorInput sfei = (SourceFileEditorInput)input;
                fileName = sfei.getName();
                this.text.setText(content, this.getMode(), sfei.isReadOnly(), sfei.isBreakpointsEnabled(), sfei.getRow());
            } else {
                this.text.setText(content, this.getMode(), false, false, 0);
            }
        }
        catch (ContentProviderException e) {
            logger.error(CANNOT_LOAD_DOCUMENT, (Throwable)e);
            if (fileName != null) {
                MessageDialog.openError(null, (String)ERROR, (String)(String.valueOf(CANNOT_LOAD_DOCUMENT) + " " + fileName));
            }
            MessageDialog.openError(null, (String)ERROR, (String)CANNOT_LOAD_DOCUMENT);
        }
        this.text.setListener(new IEditorWidgetListener(){

            public void dirtyStateChanged(boolean dirty) {
                textEditor.setDirty(dirty);
            }

            public void save() {
                JavaScriptEditor.this.doSave(null);
            }

            public void setBreakpoint(int row) {
                DebugModel debugModel;
                IEditorInput editorInput = JavaScriptEditor.this.getEditorInput();
                if (editorInput instanceof FileEditorInput && (debugModel = DebugModelFacade.getDebugModel()) != null) {
                    debugModel.getDebugController().setBreakpoint(CommonUtils.formatToRuntimePath((String)"ScriptingServices", (String)((FileEditorInput)editorInput).getPath().toString()), row);
                }
            }

            public void clearBreakpoint(int row) {
                DebugModel debugModel;
                IEditorInput editorInput = JavaScriptEditor.this.getEditorInput();
                if (editorInput instanceof FileEditorInput && (debugModel = DebugModelFacade.getDebugModel()) != null) {
                    String formatToRuntimePath = CommonUtils.formatToRuntimePath((String)"ScriptingServices", (String)((FileEditorInput)editorInput).getPath().toString());
                    debugModel.getDebugController().clearBreakpoint(formatToRuntimePath, row);
                }
            }
        });
    }

    private EditorMode getMode() {
        IEditorInput input = this.getEditorInput();
        String name = input.getName();
        String ext = name.substring(name.lastIndexOf(46) + 1);
        return EditorMode.getByExtension((String)ext);
    }

    protected String getEditorContents() {
        return this.text != null ? this.text.getText() : null;
    }

    protected Control getEditorControl() {
        return this.text;
    }

    protected void setDirty(boolean b) {
        super.setDirty(b);
        if (this.text != null) {
            this.text.setDirty(b);
        }
    }

    public void setDebugRow(int row) {
        if (this.text != null) {
            this.text.setDebugRow(row);
        }
    }
}

