/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer;
import org.eclipse.dirigible.ide.db.viewer.views.TableDefinition;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DatabaseViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Logger logger = Logger.getLogger(DatabaseViewContentProvider.class);
    private static final String DIRIGIBLE_SYSTEM_TALBES_PREFIX = "DGB_";
    private static final String PRCNT = "%";
    private static final String EMPTY = "";
    private static final String CBC = "] ";
    private static final String CBO = " [";
    private static final long serialVersionUID = 8868769345708033548L;
    private TreeParent invisibleRoot;
    public DatabaseViewer databaseViewer;

    public DatabaseViewContentProvider(DatabaseViewer databaseViewer) {
        this.databaseViewer = databaseViewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.databaseViewer.getViewSite())) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        try {
            Connection connection = this.databaseViewer.getDatabaseConnection();
            try {
                DatabaseMetaData dmd = connection.getMetaData();
                TreeParent schemes = null;
                ArrayList<TreeParent> schemesMid = new ArrayList<TreeParent>();
                schemes = new TreeParent(String.valueOf(CommonParameters.getDatabaseProductName()) + CBO + CommonParameters.getDatabaseProductVersion() + CBC + CommonParameters.getDriverName(), this.databaseViewer);
                boolean isOperator = CommonParameters.isUserInRole((String)"Operator");
                String catalogName = null;
                List<String> listOfSchemes = this.getListOfSchemes(connection, catalogName);
                Iterator<String> iterator = listOfSchemes.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String schemeName = string = iterator.next();
                    TreeParent scheme = new TreeParent(schemeName, this.databaseViewer);
                    List<String> listOfTables = this.getListOfTables(dmd, catalogName, schemeName);
                    for (String tableName : listOfTables) {
                        if (!isOperator && tableName.startsWith(DIRIGIBLE_SYSTEM_TALBES_PREFIX)) continue;
                        TreeObject toTable = new TreeObject(tableName, new TableDefinition(catalogName, schemeName, tableName));
                        scheme.addChild(toTable);
                    }
                    schemesMid.add(scheme);
                }
                this.invisibleRoot = new TreeParent(EMPTY, this.databaseViewer);
                if (this.databaseViewer.showSchemes() || schemesMid.size() > 1) {
                    for (TreeParent treeParent : schemesMid) {
                        schemes.addChild(treeParent);
                    }
                    this.invisibleRoot.addChild(schemes);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            TreeParent root = new TreeParent(e.getMessage(), this.databaseViewer);
            this.invisibleRoot = new TreeParent(EMPTY, this.databaseViewer);
            this.invisibleRoot.addChild(root);
        }
    }

    private List<String> getListOfSchemes(Connection connection, String catalogName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        ArrayList<String> listOfSchemes = new ArrayList<String>();
        ResultSet rs = null;
        String productName = CommonParameters.getDatabaseProductName();
        IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier((String)productName);
        IFilter schemaFilter = this.databaseViewer.getSchemaFilter(connection);
        try {
            if (dialectSpecifier.isSchemaFilterSupported()) {
                try {
                    rs = connection.createStatement().executeQuery(dialectSpecifier.getSchemaFilterScript());
                }
                catch (Exception exception) {
                    rs = metaData.getSchemas(catalogName, null);
                }
            } else {
                rs = dialectSpecifier.isCatalogForSchema() ? metaData.getCatalogs() : metaData.getSchemas(catalogName, null);
            }
            while (rs.next()) {
                String schemeName = rs.getString(1);
                if (schemaFilter != null && !schemaFilter.select((Object)schemeName)) continue;
                listOfSchemes.add(schemeName);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return listOfSchemes;
    }

    private List<String> getListOfTables(DatabaseMetaData dmd, String catalogName, String schemeName) throws SQLException {
        String productName = CommonParameters.getDatabaseProductName();
        IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier((String)productName);
        ArrayList<String> listOfTables = new ArrayList<String>();
        ResultSet rs = null;
        rs = dialectSpecifier.isCatalogForSchema() ? dmd.getTables(schemeName, null, PRCNT, DBUtils.TABLE_TYPES) : dmd.getTables(catalogName, schemeName, PRCNT, DBUtils.TABLE_TYPES);
        while (rs.next()) {
            String tableName = rs.getString(3);
            listOfTables.add(tableName);
        }
        rs.close();
        return listOfTables;
    }

    public void requestRefreshContent() {
        this.invisibleRoot = null;
    }
}

