/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class RequestCounter
implements SerializableCompatibility {
    private static final String ATTR_INSTANCE = String.valueOf(RequestCounter.class.getName()) + "#instance:";
    private final AtomicInteger requestId = new AtomicInteger();

    private RequestCounter() {
    }

    public static RequestCounter getInstance() {
        HttpServletRequest request = ContextProvider.getRequest();
        String connectionId = request.getParameter("cid");
        String attributeName = RequestCounter.getRequestCounterAttributeName(connectionId);
        HttpSession httpSession = ContextProvider.getUISession().getHttpSession();
        RequestCounter result = (RequestCounter)httpSession.getAttribute(attributeName);
        if (result == null) {
            result = new RequestCounter();
            httpSession.setAttribute(attributeName, (Object)result);
        }
        return result;
    }

    public static void reattachToHttpSession(HttpSession httpSession, String connectionId) {
        String attributeName = RequestCounter.getRequestCounterAttributeName(connectionId);
        Object value = httpSession.getAttribute(attributeName);
        httpSession.setAttribute(attributeName, value);
    }

    public int nextRequestId() {
        return this.requestId.incrementAndGet();
    }

    public int currentRequestId() {
        return this.requestId.get();
    }

    private static String getRequestCounterAttributeName(String connectionId) {
        return String.valueOf(ATTR_INSTANCE) + (connectionId == null ? "" : connectionId);
    }
}

