/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.generatortasks.restadapter.AdapterGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.HelperClassesGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.ProvidedPortWorkerGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.RESTServiceConfig;
import org.eclipse.comma.project.generatortasks.restadapter.RequiredPortApiGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.RequiredPortWorkerGenerator;
import org.eclipse.comma.project.generatortasks.restadapter.RequiredPortsWSServerGenerator;
import org.eclipse.comma.project.project.RESTAdapterTask;
import org.eclipse.comma.project.project.RESTServiceSpecification;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.scoping.TypesImportUriGlobalScopeProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RESTAdapterGeneratorTask
extends GeneratorTask {
    protected final RESTAdapterTask task;
    protected final CommaFileSystemAccess javaFileSystemAccess;

    public RESTAdapterGeneratorTask(RESTAdapterTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        CommaFileSystemAccess _commaFileSystemAccess;
        this.task = task;
        String _name = task.getName();
        String _plus = String.valueOf(_name) + "/java/org/eclipse/comma/restadapter/";
        this.javaFileSystemAccess = _commaFileSystemAccess = new CommaFileSystemAccess(_plus, fsa);
    }

    @Override
    protected void doGenerate() throws IllegalArgumentException {
        ArrayList<RESTServiceConfig> restServiceConfigs = this.makeRestServiceConfigs();
        this.generateAdapter(restServiceConfigs);
        this.generateProvidedPortWorkers(restServiceConfigs);
        this.generateEnumAndRecordTypes(restServiceConfigs);
        this.generateRequiredPortApis(restServiceConfigs);
        this.generateRequiredPortWorkers(restServiceConfigs);
        this.generateRequiredPortsWSServers(restServiceConfigs);
    }

    public void generateAdapter(List<RESTServiceConfig> restServiceConfigs) {
        AdapterGenerator.generate(this.task.getComponent(), restServiceConfigs, this.javaFileSystemAccess);
    }

    public void generateProvidedPortWorkers(List<RESTServiceConfig> restServiceConfigs) {
        for (RESTServiceConfig serviceConfig : restServiceConfigs) {
            Port _get = serviceConfig.ports.get(0);
            if (!(_get instanceof ProvidedPort)) continue;
            for (Port port : serviceConfig.ports) {
                ProvidedPortWorkerGenerator.generate(this.javaFileSystemAccess, port.getInterface(), serviceConfig.pathMappings);
            }
        }
    }

    public void generateEnumAndRecordTypes(List<RESTServiceConfig> restServiceConfigs) {
        for (RESTServiceConfig serviceConfig : restServiceConfigs) {
            ArrayList<URI> allImportedURIs = new ArrayList<URI>();
            LinkedHashSet<URI> knownURIs = new LinkedHashSet<URI>(5);
            List<Signature> signatures = ProjectUtility.getSignaturesForRESTTask(serviceConfig.restTask, this.scopeProvider);
            for (Signature s : signatures) {
                knownURIs.add(s.eResource().getURI());
                LinkedHashSet _traverseImportedURIs = TypesImportUriGlobalScopeProvider.traverseImportedURIs((Resource)s.eResource(), knownURIs);
                for (URI uri : _traverseImportedURIs) {
                    boolean _not;
                    boolean _contains = allImportedURIs.contains(uri);
                    boolean bl = _not = !_contains;
                    if (!_not) continue;
                    allImportedURIs.add(uri);
                }
            }
            for (URI uri : allImportedURIs) {
                Resource resource = EcoreUtil2.getResource((Resource)this.task.eResource(), (String)uri.toString());
                if (resource == null) continue;
                HelperClassesGenerator.generateClassesFromResource(this.javaFileSystemAccess, resource);
            }
        }
    }

    public ArrayList<RESTServiceConfig> makeRestServiceConfigs() {
        ArrayList<RESTServiceConfig> restServices = new ArrayList<RESTServiceConfig>();
        EList<RESTServiceSpecification> _restServiceSpecifications = this.task.getRestServiceSpecifications();
        for (RESTServiceSpecification restServiceSpec : _restServiceSpecifications) {
            RESTServiceConfig serviceConfig = new RESTServiceConfig();
            serviceConfig.ports = restServiceSpec.getPorts();
            serviceConfig.urlREST = restServiceSpec.getRestTask().getRestServerURL();
            serviceConfig.urlWS = restServiceSpec.getRestTask().getAsyncServerURL();
            serviceConfig.pathMappings = restServiceSpec.getRestTask().getPathMappings();
            serviceConfig.restTask = restServiceSpec.getRestTask();
            restServices.add(serviceConfig);
        }
        return restServices;
    }

    public void generateRequiredPortApis(List<RESTServiceConfig> restServiceConfigs) {
        for (RESTServiceConfig serviceConfig : restServiceConfigs) {
            Port _get = serviceConfig.ports.get(0);
            if (!(_get instanceof RequiredPort)) continue;
            RequiredPortApiGenerator.generate(this.javaFileSystemAccess, serviceConfig);
        }
    }

    public void generateRequiredPortWorkers(List<RESTServiceConfig> restServiceConfigs) {
        for (RESTServiceConfig serviceConfig : restServiceConfigs) {
            Port _get = serviceConfig.ports.get(0);
            if (!(_get instanceof RequiredPort)) continue;
            Functions.Function1 _function = it -> it.getInterface();
            Set signatures = IterableExtensions.toSet((Iterable)ListExtensions.map(serviceConfig.ports, (Functions.Function1)_function));
            for (Signature sig : signatures) {
                RequiredPortWorkerGenerator.generate(this.javaFileSystemAccess, sig, serviceConfig.restTask);
            }
        }
    }

    public void generateRequiredPortsWSServers(List<RESTServiceConfig> restServiceConfigs) {
        for (RESTServiceConfig serviceConfig : restServiceConfigs) {
            Port _get = serviceConfig.ports.get(0);
            if (!(_get instanceof RequiredPort)) continue;
            Functions.Function1 _function = it -> it.getInterface();
            List signatures = IterableExtensions.toList((Iterable)ListExtensions.map(serviceConfig.ports, (Functions.Function1)_function));
            RequiredPortsWSServerGenerator.generate(this.javaFileSystemAccess, signatures, serviceConfig.restTask);
        }
    }
}

