/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.ApiJavadocTag;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public final class JavadocTagManager {
    public static final String TAG_NOINSTANTIATE = "@noinstantiate";
    public static final String ANNOTATION_NOINSTANTIATE = "NoInstantiate";
    public static final String TAG_NOEXTEND = "@noextend";
    public static final String ANNOTATION_NOEXTEND = "NoExtend";
    public static final String TAG_NOIMPLEMENT = "@noimplement";
    public static final String ANNOTATION_NOIMPLEMENT = "NoImplement";
    public static final String TAG_NOOVERRIDE = "@nooverride";
    public static final String ANNOTATION_NOOVERRIDE = "NoOverride";
    public static final String TAG_NOREFERENCE = "@noreference";
    public static final String ANNOTATION_NOREFERENCE = "NoReference";
    public static final Set<String> ALL_TAGS;
    public static final Set<String> ALL_ANNOTATIONS;
    private static final HashMap<String, String> fqAnnotationNames;
    private HashMap<String, IApiJavadocTag> tagcache = null;
    private HashMap<Key, Set<String>> fAnnotationCache = null;
    private IApiJavadocTag[] tags;

    static {
        HashSet<String> tags = new HashSet<String>(5, 1.0f);
        tags.add(TAG_NOEXTEND);
        tags.add(TAG_NOIMPLEMENT);
        tags.add(TAG_NOINSTANTIATE);
        tags.add(TAG_NOOVERRIDE);
        tags.add(TAG_NOREFERENCE);
        ALL_TAGS = Collections.unmodifiableSet(tags);
        tags = new HashSet();
        tags.add(ANNOTATION_NOEXTEND);
        tags.add(ANNOTATION_NOIMPLEMENT);
        tags.add(ANNOTATION_NOINSTANTIATE);
        tags.add(ANNOTATION_NOOVERRIDE);
        tags.add(ANNOTATION_NOREFERENCE);
        ALL_ANNOTATIONS = Collections.unmodifiableSet(tags);
        fqAnnotationNames = new HashMap();
        fqAnnotationNames.put(ANNOTATION_NOEXTEND, "org.eclipse.pde.api.tools.annotations.NoExtend");
        fqAnnotationNames.put(ANNOTATION_NOIMPLEMENT, "org.eclipse.pde.api.tools.annotations.NoImplement");
        fqAnnotationNames.put(ANNOTATION_NOINSTANTIATE, "org.eclipse.pde.api.tools.annotations.NoInstantiate");
        fqAnnotationNames.put(ANNOTATION_NOOVERRIDE, "org.eclipse.pde.api.tools.annotations.NoOverride");
        fqAnnotationNames.put(ANNOTATION_NOREFERENCE, "org.eclipse.pde.api.tools.annotations.NoReference");
    }

    private void initializeAnnotations() {
        if (this.fAnnotationCache == null) {
            this.fAnnotationCache = new HashMap();
            HashSet<String> annots = new HashSet<String>();
            annots.add(ANNOTATION_NOEXTEND);
            annots.add(ANNOTATION_NOINSTANTIATE);
            annots.add(ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 16), annots);
            annots = new HashSet();
            annots.add(ANNOTATION_NOEXTEND);
            annots.add(ANNOTATION_NOIMPLEMENT);
            annots.add(ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(2, 16), annots);
            annots = new HashSet();
            annots.add(ANNOTATION_NOOVERRIDE);
            annots.add(ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 4), annots);
            this.fAnnotationCache.put(new Key(1, 32), annots);
            this.fAnnotationCache.put(new Key(2, 4), annots);
            annots = new HashSet();
            annots.add(ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 8), annots);
            this.fAnnotationCache.put(new Key(2, 8), annots);
            this.fAnnotationCache.put(new Key(128, 16), annots);
            this.fAnnotationCache.put(new Key(64, 16), annots);
            this.fAnnotationCache.put(new Key(64, 8), annots);
            this.fAnnotationCache.put(new Key(64, 4), annots);
        }
    }

    private void initializeJavadocTags() {
        if (this.tagcache == null) {
            this.tagcache = new LinkedHashMap<String, IApiJavadocTag>();
            ArrayList<ApiJavadocTag> list = new ArrayList<ApiJavadocTag>(4);
            ApiJavadocTag newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noimplement", "noimplement", 1);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_implement);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noextend", "noextend", 2);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_subclass);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_extend);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.nooverride", "nooverride", 16);
            newtag.setApplicableTo(1, 4, CoreMessages.JavadocTagManager_method_no_overried);
            newtag.setApplicableTo(2, 4, CoreMessages.JavadocTagManager_default_method_no_override);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noinstantiate", "noinstantiate", 4);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_instantiate);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noreference", "noreference", 8);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_reference);
            newtag.setApplicableTo(1, 4, CoreMessages.JavadocTagManager_method_no_reference);
            newtag.setApplicableTo(1, 32, CoreMessages.JavadocTagManager_constructor_no_reference);
            newtag.setApplicableTo(1, 8, CoreMessages.JavadocTagManager_field_no_reference);
            newtag.setApplicableTo(2, 4, CoreMessages.JavadocTagManager_method_no_reference);
            newtag.setApplicableTo(2, 8, CoreMessages.JavadocTagManager_field_no_reference);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_reference);
            newtag.setApplicableTo(64, 16, CoreMessages.JavadocTagManager_enum_no_reference);
            newtag.setApplicableTo(64, 8, CoreMessages.JavadocTagManager_enum_field_no_reference);
            newtag.setApplicableTo(64, 4, CoreMessages.JavadocTagManager_enum_method_no_reference);
            newtag.setApplicableTo(128, 16, CoreMessages.JavadocTagManager_annotation_no_reference);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            this.tags = list.toArray(new IApiJavadocTag[list.size()]);
        }
    }

    public synchronized IApiJavadocTag[] getTagsForType(int type, int member) {
        this.initializeJavadocTags();
        ArrayList<IApiJavadocTag> list = new ArrayList<IApiJavadocTag>();
        IApiJavadocTag[] iApiJavadocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            if (tag.isApplicable(type, member)) {
                list.add(tag);
            }
            ++n2;
        }
        return list.toArray(new IApiJavadocTag[list.size()]);
    }

    public synchronized Set<String> getAnntationsForType(int type, int member) {
        this.initializeAnnotations();
        Set<String> values = this.fAnnotationCache.get(new Key(type, member));
        if (values != null) {
            return values;
        }
        return Collections.emptySet();
    }

    public synchronized String getQualifiedNameForAnnotation(String typename) {
        return fqAnnotationNames.get(typename);
    }

    public synchronized IApiJavadocTag getTag(String id) {
        this.initializeJavadocTags();
        return this.tagcache.get(id);
    }

    public synchronized IApiJavadocTag[] getAllTags() {
        this.initializeJavadocTags();
        if (this.tagcache == null) {
            return new IApiJavadocTag[0];
        }
        Collection<IApiJavadocTag> values = this.tagcache.values();
        return values.toArray(new IApiJavadocTag[values.size()]);
    }

    public synchronized Set<String> getAllTagNames() {
        IApiJavadocTag[] tags = this.getAllTags();
        HashSet<String> names = new HashSet<String>(tags.length);
        IApiJavadocTag[] iApiJavadocTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            names.add(tag.getTagName());
            ++n2;
        }
        return names;
    }

    public synchronized int getRestrictionsForTag(String tagname, int type, int member) {
        if (tagname == null) {
            return 0;
        }
        this.initializeJavadocTags();
        IApiJavadocTag[] iApiJavadocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            if (tag.getTagName().equals(tagname) && tag.isApplicable(type, member)) {
                return tag.getRestrictionModifier();
            }
            ++n2;
        }
        return 0;
    }

    class Key {
        int type;
        int member;

        public Key(int t, int m) {
            this.type = t;
            this.member = m;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.type == other.type && this.member == other.member;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.type + this.member;
        }
    }
}

