/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class SinceTagVersion {
    private String prefixString;
    private Version version;
    private String versionString;
    private String postfixString;
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+\\.?[0-9]?\\.?[0-9]?\\.?[A-Za-z0-9]*)");

    public SinceTagVersion(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        char[] chars = value.toCharArray();
        int mode = 0;
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            switch (mode) {
                case 0: {
                    switch (currentChar) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            mode = 1;
                            --i;
                        }
                    }
                    break;
                }
                case 1: {
                    int start = i;
                    while (i < max) {
                        if (Character.isWhitespace(currentChar) || !Character.isLetterOrDigit(currentChar) && currentChar != '.') break;
                        currentChar = chars[i];
                        ++i;
                    }
                    String potentialVersion = null;
                    potentialVersion = i == max ? value.substring(start, i) : value.substring(start, i - 1);
                    Matcher m = VERSION_PATTERN.matcher(potentialVersion);
                    if (m.find()) {
                        this.versionString = potentialVersion;
                        if (start != 0) {
                            this.prefixString = value.substring(0, start);
                            if (Character.isLetterOrDigit(value.charAt(start - 1))) {
                                this.versionString = null;
                                this.prefixString = null;
                                break;
                            }
                        }
                        if (i != max) {
                            this.postfixString = value.substring(i - 1);
                        }
                        try {
                            this.version = new Version(this.versionString);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        return;
                    }
                    mode = 0;
                    break;
                }
            }
            ++i;
        }
        if (this.versionString == null) {
            this.postfixString = value;
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public Version getVersion() {
        return this.version;
    }

    public String prefixString() {
        return this.prefixString;
    }

    public String postfixString() {
        return this.postfixString;
    }
}

