/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkaneIdentifier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakTableRetentionIndexViewerUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakTargetsViewerUI;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PagePeakAssignment
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PagePeakAssignment.class);
    private IRetentionIndexWizardElements wizardElements;
    private PeakTableRetentionIndexViewerUI peakTableViewerUI;
    private PeakTargetsViewerUI targetsViewerUI;
    private Combo comboStartIndexName;
    private Label labelIndexRange;
    private Combo comboStopIndexName;
    private Button buttonPrevious;
    private Text textCurrentIndexName;
    private Button buttonNext;
    private String[] availableStandards;
    private int indexSelectedStandard;
    private String databaseName;
    private static final int ACTION_INCREASE_INDEX = 1;
    private static final int ACTION_DECREASE_INDEX = 2;

    public PagePeakAssignment(IRetentionIndexWizardElements wizardElements) {
        super(PagePeakAssignment.class.getName());
        this.setTitle("Peak Assigment");
        this.setDescription("Please assign the alkanes.");
        this.wizardElements = wizardElements;
        this.availableStandards = wizardElements.getAvailableStandards();
        File file = new File(AlkaneIdentifier.getDatabase());
        this.databaseName = file.getName();
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelection chromatogramSelection = this.wizardElements.getChromatogramSelection();
            if (chromatogramSelection != null && chromatogramSelection.getChromatogram() != null) {
                this.indexSelectedStandard = this.getStartIndex(this.availableStandards, this.wizardElements.getStartIndexName());
                if (this.indexSelectedStandard > -1) {
                    this.textCurrentIndexName.setText(this.availableStandards[this.indexSelectedStandard]);
                } else {
                    this.textCurrentIndexName.setText("");
                }
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                List peaks = chromatogram.getPeaks();
                this.peakTableViewerUI.setInput((Object)peaks);
                this.peakTableViewerUI.getTable().setSelection(0);
                if (peaks.size() > 0) {
                    IPeak peak = (IPeak)peaks.get(0);
                    Set targets = peak.getTargets();
                    this.targetsViewerUI.setInput((Object)targets);
                    this.targetsViewerUI.getTable().setSelection(0);
                }
            } else {
                this.peakTableViewerUI.setInput(null);
                this.textCurrentIndexName.setText("");
            }
            this.updateLabel();
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createRetentionIndexField(composite);
        this.createAutoAssignField(composite);
        this.createPeakTableField(composite);
        this.createTargetSpinnerField(composite);
        this.createAssignIndexField(composite);
        this.createPeakTargetsField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createRetentionIndexField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataComposite = new GridData(768);
        gridDataComposite.grabExcessHorizontalSpace = true;
        gridDataComposite.horizontalSpan = 3;
        composite.setLayoutData((Object)gridDataComposite);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.comboStartIndexName = new Combo(composite, 0);
        this.comboStartIndexName.setLayoutData((Object)new GridData(768));
        this.comboStartIndexName.setItems(this.availableStandards);
        this.comboStartIndexName.setToolTipText("Select the start index.");
        this.comboStartIndexName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignment.this.wizardElements.setStartIndexName(PagePeakAssignment.this.comboStartIndexName.getText().trim());
                PagePeakAssignment.this.validateIndexSelection();
                PagePeakAssignment.this.updateLabel();
            }
        });
        this.comboStopIndexName = new Combo(composite, 0);
        this.comboStopIndexName.setLayoutData((Object)new GridData(768));
        this.comboStopIndexName.setItems(this.availableStandards);
        this.comboStopIndexName.setToolTipText("Select the stop index.");
        this.comboStopIndexName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignment.this.wizardElements.setStopIndexName(PagePeakAssignment.this.comboStopIndexName.getText().trim());
                PagePeakAssignment.this.validateIndexSelection();
                PagePeakAssignment.this.updateLabel();
            }
        });
        this.labelIndexRange = new Label(composite, 0);
        this.labelIndexRange.setText("");
        GridData gridDataLabel = new GridData(768);
        gridDataLabel.grabExcessHorizontalSpace = true;
        gridDataLabel.horizontalSpan = 2;
        this.labelIndexRange.setLayoutData((Object)gridDataLabel);
    }

    private void createAutoAssignField(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Auto Assign Standards");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IChromatogramSelection chromatogramSelection;
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setText("Auto assign standards");
                messageBox.setMessage("Would you like to set all standards automatically?");
                if (messageBox.open() == 64 && (chromatogramSelection = PagePeakAssignment.this.wizardElements.getChromatogramSelection()) != null && chromatogramSelection.getChromatogram() != null) {
                    IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                    List chromatogramPeaks = chromatogram.getPeaks();
                    List<IRetentionIndexEntry> retentionIndexEntries = PagePeakAssignment.this.wizardElements.getSelectedRetentionIndexEntries();
                    if (chromatogramPeaks.size() == retentionIndexEntries.size()) {
                        int i = 0;
                        while (i < chromatogramPeaks.size()) {
                            IPeak chromatogramPeak = (IPeak)chromatogramPeaks.get(i);
                            IRetentionIndexEntry retentionIndexEntry = retentionIndexEntries.get(i);
                            PagePeakAssignment.this.setPeakTarget(chromatogramPeak, retentionIndexEntry.getName(), true);
                            ++i;
                        }
                        PagePeakAssignment.this.peakTableViewerUI.getTable().setSelection(0);
                        chromatogramSelection.reset();
                        IPeak selectedPeak = PagePeakAssignment.this.getSelectedPeak();
                        if (selectedPeak != null) {
                            PagePeakAssignment.this.targetsViewerUI.setInput((Object)selectedPeak.getTargets());
                            PagePeakAssignment.this.targetsViewerUI.getTable().setSelection(0);
                        }
                    } else {
                        String message = "The number of peaks (" + chromatogramPeaks.size() + ") and selected standards (" + retentionIndexEntries.size() + ") is unequal.";
                        PagePeakAssignment.this.updateStatus(message);
                    }
                }
            }
        });
    }

    private void createPeakTableField(Composite parent) {
        this.peakTableViewerUI = new PeakTableRetentionIndexViewerUI(parent, 2048);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.peakTableViewerUI.getTable().setLayoutData((Object)gridData);
        this.peakTableViewerUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IPeak selectedPeak = PagePeakAssignment.this.getSelectedPeak();
                if (selectedPeak != null) {
                    PagePeakAssignment.this.targetsViewerUI.setInput((Object)selectedPeak.getTargets());
                    PagePeakAssignment.this.targetsViewerUI.getTable().setSelection(0);
                }
            }
        });
    }

    private void createTargetSpinnerField(Composite parent) {
        this.buttonPrevious = new Button(parent, 8);
        this.buttonPrevious.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/previous.gif", "16x16"));
        this.buttonPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignment.this.setCurrentIndexName(2);
            }
        });
        this.textCurrentIndexName = new Text(parent, 2048);
        this.textCurrentIndexName.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textCurrentIndexName.setLayoutData((Object)gridData);
        this.buttonNext = new Button(parent, 8);
        this.buttonNext.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/next.gif", "16x16"));
        this.buttonNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignment.this.setCurrentIndexName(1);
            }
        });
    }

    private void createAssignIndexField(Composite parent) {
        Button buttonAdd = new Button(parent, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        buttonAdd.setLayoutData((Object)gridData);
        buttonAdd.setText("Replace peak targets by selected index");
        buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute_add.gif", "16x16"));
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPeak selectedPeak = PagePeakAssignment.this.getSelectedPeak();
                if (selectedPeak != null) {
                    String name = PagePeakAssignment.this.textCurrentIndexName.getText().trim();
                    PagePeakAssignment.this.setPeakTarget(selectedPeak, name, true);
                }
            }
        });
    }

    private void setPeakTarget(IPeak peak, String name, boolean deleteOtherTargets) {
        if (deleteOtherTargets) {
            peak.getTargets().clear();
        }
        try {
            float FACTOR = 100.0f;
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setName(name);
            libraryInformation.setDatabase(this.databaseName);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(FACTOR, FACTOR, FACTOR, FACTOR, FACTOR);
            IdentificationTarget peakTarget = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
            peakTarget.setIdentifier("Alkane Identifier");
            peak.getTargets().add(peakTarget);
            this.targetsViewerUI.setInput((Object)peak.getTargets());
            this.setCurrentIndexName(1);
        }
        catch (ReferenceMustNotBeNullException e1) {
            logger.warn((Object)e1);
        }
    }

    private void createPeakTargetsField(Composite parent) {
        this.targetsViewerUI = new PeakTargetsViewerUI(parent, 2050);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.targetsViewerUI.getTable().setLayoutData((Object)gridData);
        this.targetsViewerUI.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    IPeak chromatogramPeakMSD;
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    messageBox.setText("Delete identification(s)");
                    messageBox.setMessage("Would you like to delete the identification(s)?");
                    if (messageBox.open() == 64 && (chromatogramPeakMSD = PagePeakAssignment.this.getSelectedPeak()) != null) {
                        Table table = PagePeakAssignment.this.targetsViewerUI.getTable();
                        int[] indices = table.getSelectionIndices();
                        List targetsToRemove = PagePeakAssignment.this.getPeakTargetList(table, indices);
                        chromatogramPeakMSD.getTargets().removeAll(targetsToRemove);
                        PagePeakAssignment.this.targetsViewerUI.setInput((Object)chromatogramPeakMSD.getTargets());
                        PagePeakAssignment.this.validateSelection();
                    }
                }
            }
        });
    }

    private IPeak getSelectedPeak() {
        Table table = this.peakTableViewerUI.getTable();
        int index = table.getSelectionIndex();
        Object object = this.peakTableViewerUI.getElementAt(index);
        if (object instanceof IPeak) {
            return (IPeak)object;
        }
        return null;
    }

    private int getStartIndex(String[] availableStandards, String startIndexName) {
        int i = 0;
        while (i < availableStandards.length) {
            if (availableStandards[i].equals(startIndexName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setCurrentIndexName(int action) {
        switch (action) {
            case 1: {
                this.buttonPrevious.setEnabled(true);
                ++this.indexSelectedStandard;
                if (this.indexSelectedStandard < this.availableStandards.length) break;
                this.indexSelectedStandard = this.availableStandards.length - 1;
                this.buttonNext.setEnabled(false);
                break;
            }
            case 2: {
                this.buttonNext.setEnabled(true);
                --this.indexSelectedStandard;
                if (this.indexSelectedStandard >= 0) break;
                this.indexSelectedStandard = 0;
                this.buttonPrevious.setEnabled(false);
            }
        }
        this.textCurrentIndexName.setText(this.availableStandards[this.indexSelectedStandard]);
    }

    private List<IIdentificationTarget> getPeakTargetList(Table table, int[] indices) {
        ArrayList<IIdentificationTarget> targetList = new ArrayList<IIdentificationTarget>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IIdentificationTarget) {
                IIdentificationTarget target = (IIdentificationTarget)object;
                targetList.add(target);
            }
            ++n2;
        }
        return targetList;
    }

    private void validateSelection() {
        String message = null;
        this.updateStatus(message);
    }

    private void updateLabel() {
        List<IRetentionIndexEntry> retentionIndexEntries = this.wizardElements.getSelectedRetentionIndexEntries();
        int size = this.wizardElements.getChromatogramSelection().getChromatogram().getPeaks().size();
        this.labelIndexRange.setText("Number of peaks (" + size + ") -> Selected Standards (" + retentionIndexEntries.size() + ")");
    }

    private void validateIndexSelection() {
        String message = null;
        if (message == null) {
            String startIndexName = this.wizardElements.getStartIndexName();
            if (startIndexName.equals("")) {
                message = "Please select and start index.";
            } else if (this.getComboIndex(startIndexName) == -1) {
                message = "The select start index is not valid.";
            }
        }
        if (message == null) {
            String stopIndexName = this.wizardElements.getStopIndexName();
            if (stopIndexName.equals("")) {
                message = "Please select and stop index.";
            } else if (this.getComboIndex(stopIndexName) == -1) {
                message = "The select stop index is not valid.";
            }
        }
        this.updateStatus(message);
    }

    private int getComboIndex(String name) {
        int i = 0;
        while (i < this.availableStandards.length) {
            if (this.availableStandards[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

